/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.inventorio.mixin;

import me.lizardofoz.inventorio.client.control.InventorioKeyHandler;
import me.lizardofoz.inventorio.player.inventory.PlayerInventoryExtension;
import me.lizardofoz.inventorio.util.MixinHelpers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1661.class}, priority=-5000)
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public class_1657 field_7546;

    @Inject(method={"clone"}, at={@At(value="RETURN")})
    private void inventorioClonePlayerInventory(class_1661 sourceInventory, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, thisAddon -> MixinHelpers.withInventoryAddon(sourceInventory.field_7546, thisAddon::cloneFrom));
    }

    @Inject(method={"getMainHandStack"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetMainHandStack(CallbackInfoReturnable<class_1799> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            class_1799 mainHandStack = inventorioAddon.getDisplayedMainHandStack();
            if (mainHandStack != null) {
                cir.setReturnValue((Object)mainHandStack);
            }
        });
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> cir.setReturnValue((Object)Float.valueOf(inventorioAddon.getMiningSpeedMultiplier(block))));
    }

    @Inject(method={"insertStack(ILnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioInsertSimilarStackIntoAddon(int slot, class_1799 originalStack, CallbackInfoReturnable<Boolean> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            if (slot == -1 && inventorioAddon != null && inventorioAddon.insertOnlySimilarStack(originalStack)) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @Inject(method={"insertStack(ILnet/minecraft/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioInsertStackIntoAddon(int slot, class_1799 originalStack, CallbackInfoReturnable<Boolean> cir) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            if (slot == -1 && !((Boolean)cir.getReturnValue()).booleanValue() && inventorioAddon != null && inventorioAddon.insertStackIntoEmptySlot(originalStack)) {
                cir.setReturnValue((Object)true);
            }
        });
    }

    @Inject(method={"removeOne"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioRemoveOneFromAddon(class_1799 stack, CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, inventorioAddon -> {
            if (inventorioAddon != null && inventorioAddon.removeOne(stack)) {
                ci.cancel();
            }
        });
    }

    @Inject(method={"dropAll"}, at={@At(value="RETURN")})
    private void inventorioDropAllFromAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, PlayerInventoryExtension::dropAll);
    }

    @Inject(method={"clear"}, at={@At(value="RETURN")})
    private void inventorioClearAddon(CallbackInfo ci) {
        MixinHelpers.withInventoryAddon(this.field_7546, class_1277::method_5448);
    }

    @Inject(method={"scrollInHotbar"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    private void inventorioScrollInHotbar(double scrollAmount, CallbackInfo ci) {
        if (InventorioKeyHandler.INSTANCE.scrollInHotbar(this.field_7546, scrollAmount)) {
            ci.cancel();
        }
    }
}

