/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.inventorio.player.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import me.lizardofoz.inventorio.api.ToolBeltSlotTemplate;
import me.lizardofoz.inventorio.config.GlobalSettings;
import me.lizardofoz.inventorio.enchantment.DeepPocketsEnchantment;
import me.lizardofoz.inventorio.mixin.accessor.SimpleInventoryAccessor;
import me.lizardofoz.inventorio.packet.InventorioNetworking;
import me.lizardofoz.inventorio.player.PlayerInventoryAddon;
import me.lizardofoz.inventorio.util.GeneralConstants;
import me.lizardofoz.inventorio.util.RandomStuff;
import me.lizardofoz.inventorio.util.RangeIteratorKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007J\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0$2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0016J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\fJ\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010+\u001a\u00020'J\u001c\u0010,\u001a\u00020\u001a2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070.H\u0007J\b\u0010/\u001a\u00020\u001aH\u0004J\u000e\u00100\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\fJ\u0016\u00101\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u0016R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lme/lizardofoz/inventorio/player/inventory/PlayerInventoryExtension;", "Lnet/minecraft/inventory/SimpleInventory;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "(Lnet/minecraft/entity/player/PlayerEntity;)V", "deepPockets", "", "Lnet/minecraft/item/ItemStack;", "lastTrackedStacksState", "getPlayer", "()Lnet/minecraft/entity/player/PlayerEntity;", "value", "", "selectedUtility", "getSelectedUtility", "()I", "setSelectedUtility", "(I)V", "stacks", "toolBelt", "utilityBelt", "areItemsSimilar", "", "stack1", "stack2", "cloneFrom", "", "oldAddon", "Lme/lizardofoz/inventorio/player/PlayerInventoryAddon;", "dropAll", "findEmptyUtility", "direction", "findFittingToolBeltIndex", "sampleStack", "findFittingToolBeltStack", "findNextUtility", "Lkotlin/Pair;", "skipEmptySlots", "getAvailableDeepPocketsRange", "Lkotlin/ranges/IntRange;", "getAvailableUtilityBeltSize", "getDeepPocketsRowCount", "getTotalAmount", "getUnavailableDeepPocketsRange", "receiveStacksUpdateS2C", "updatedStacks", "", "sendUpdateS2C", "switchToEmptyUtility", "switchToNextUtility", "inventorio"})
public abstract class PlayerInventoryExtension
extends class_1277 {
    @NotNull
    private final class_1657 player;
    @JvmField
    @NotNull
    public final List<class_1799> stacks;
    @JvmField
    @NotNull
    public final List<class_1799> deepPockets;
    @JvmField
    @NotNull
    public final List<class_1799> utilityBelt;
    @JvmField
    @NotNull
    public final List<class_1799> toolBelt;
    @NotNull
    private final List<class_1799> lastTrackedStacksState;
    private int selectedUtility;

    protected PlayerInventoryExtension(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(35 + PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio().size());
        this.player = player;
        class_2371 class_23712 = ((SimpleInventoryAccessor)((Object)this)).getStacks();
        Intrinsics.checkNotNull(class_23712);
        this.stacks = (List)class_23712;
        this.deepPockets = this.stacks.subList(GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE.getFirst(), GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE.getLast() + 1);
        this.utilityBelt = this.stacks.subList(GeneralConstants.INVENTORY_ADDON_UTILITY_BELT_RANGE.getFirst(), GeneralConstants.INVENTORY_ADDON_UTILITY_BELT_RANGE.getLast() + 1);
        this.toolBelt = this.stacks.subList(GeneralConstants.INVENTORY_ADDON_TOOL_BELT_INDEX_OFFSET, GeneralConstants.INVENTORY_ADDON_TOOL_BELT_INDEX_OFFSET + PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio().size());
        class_23712 = class_2371.method_10213((int)this.stacks.size(), (Object)class_1799.field_8037);
        Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"ofSize(stacks.size, ItemStack.EMPTY)");
        this.lastTrackedStacksState = (List)class_23712;
    }

    @NotNull
    public final class_1657 getPlayer() {
        return this.player;
    }

    public final int getSelectedUtility() {
        return this.selectedUtility;
    }

    public final void setSelectedUtility(int value) {
        this.selectedUtility = RangesKt.coerceIn((int)value, (int)0, (int)7);
    }

    protected final void sendUpdateS2C() {
        boolean bl = false;
        Map stacksToUpdate = new LinkedHashMap();
        Object object = this.stacks.iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            class_1799 stack = (class_1799)object.next();
            if (class_1799.method_7973((class_1799)stack, (class_1799)this.lastTrackedStacksState.get(index))) continue;
            Object object2 = stack.method_7972();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"stack.copy()");
            this.lastTrackedStacksState.set(index, (class_1799)object2);
            object2 = stacksToUpdate;
            Integer n2 = index;
            class_1799 class_17992 = stack.method_7972();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"stack.copy()");
            boolean bl2 = false;
            object2.put(n2, class_17992);
        }
        object = stacksToUpdate;
        n = 0;
        if (!object.isEmpty()) {
            InventorioNetworking.Companion.getInstance().s2cUpdateAddonStacks((class_3222)this.player, stacksToUpdate);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final void receiveStacksUpdateS2C(@NotNull Map<Integer, class_1799> updatedStacks) {
        Intrinsics.checkNotNullParameter(updatedStacks, (String)"updatedStacks");
        Object object = updatedStacks;
        boolean bl = false;
        Iterator<Map.Entry<Integer, class_1799>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            int index = ((Number)object2.getKey()).intValue();
            Object object3 = object;
            boolean bl3 = false;
            class_1799 stack = (class_1799)object3.getValue();
            this.stacks.set(index, stack);
        }
    }

    public final void cloneFrom(@NotNull PlayerInventoryAddon oldAddon) {
        Intrinsics.checkNotNullParameter((Object)((Object)oldAddon), (String)"oldAddon");
        Iterator iterator = oldAddon.stacks.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            class_1799 stack = (class_1799)iterator.next();
            this.method_5447(index, stack);
        }
    }

    public final void dropAll() {
        Iterator<class_1799> iterator = this.stacks.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            class_1799 itemStack = iterator.next();
            if (!class_1890.method_8221((class_1799)itemStack)) {
                this.player.method_7329(itemStack, true, false);
            }
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            this.stacks.set(index, class_17992);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalAmount(@NotNull class_1799 sampleStack) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)sampleStack, (String)"sampleStack");
        int count = 0;
        int n = 0;
        int n2 = this.player.method_31548().method_5439();
        if (n < n2) {
            do {
                int i = n++;
                class_1799 stack = this.player.method_31548().method_5438(i);
                Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
                if (!this.areItemsSimilar(stack, sampleStack)) continue;
                count += stack.method_7947();
            } while (n < n2);
        }
        Iterable iterable = this.stacks;
        int n3 = count;
        boolean $i$f$filter = false;
        void i = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_1799 it = (class_1799)element$iv$iv;
            boolean bl = false;
            if (!this.areItemsSimilar(it, sampleStack)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        iterable = list;
        n2 = 0;
        int n4 = 0;
        for (Object t : iterable) {
            void it;
            class_1799 class_17992 = (class_1799)t;
            int n5 = n4;
            boolean bl = false;
            int n6 = it.method_7947();
            n4 = n5 + n6;
        }
        int n7 = n4;
        return n3 + n7;
    }

    public final boolean switchToNextUtility(int direction, boolean skipEmptySlots) {
        int slotIndex = ((Number)this.findNextUtility(direction, skipEmptySlots).getSecond()).intValue();
        if (slotIndex == -1) {
            return false;
        }
        this.setSelectedUtility(slotIndex);
        InventorioNetworking.Companion.getInstance().c2sSelectUtilitySlot(slotIndex);
        return true;
    }

    @NotNull
    public final Pair<class_1799, Integer> findNextUtility(int direction, boolean skipEmptySlots) {
        List range = MathKt.getSign((int)direction) >= 0 ? CollectionsKt.plus((Iterable)((Iterable)RangesKt.until((int)(this.selectedUtility + 1), (int)this.getAvailableUtilityBeltSize())), (Iterable)((Iterable)RangesKt.until((int)0, (int)this.selectedUtility))) : CollectionsKt.plus((Iterable)((Iterable)RangesKt.downTo((int)(this.selectedUtility - 1), (int)0)), (Iterable)((Iterable)RangesKt.downTo((int)(this.getAvailableUtilityBeltSize() - 1), (int)(this.selectedUtility + 1))));
        Iterator iterator = range.iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            if (skipEmptySlots && !RandomStuff.isNotEmpty(this.utilityBelt.get(i))) continue;
            return new Pair((Object)this.utilityBelt.get(i), (Object)i);
        }
        return new Pair((Object)class_1799.field_8037, (Object)-1);
    }

    public final boolean switchToEmptyUtility(int direction) {
        int slotIndex = this.findEmptyUtility(direction);
        if (slotIndex == -1) {
            return false;
        }
        this.setSelectedUtility(slotIndex);
        InventorioNetworking.Companion.getInstance().c2sSelectUtilitySlot(slotIndex);
        return true;
    }

    public final int findEmptyUtility(int direction) {
        List range = MathKt.getSign((int)direction) >= 0 ? CollectionsKt.plus((Iterable)((Iterable)RangesKt.until((int)(this.selectedUtility + 1), (int)this.getAvailableUtilityBeltSize())), (Iterable)((Iterable)RangesKt.until((int)0, (int)this.selectedUtility))) : CollectionsKt.plus((Iterable)((Iterable)RangesKt.downTo((int)(this.selectedUtility - 1), (int)0)), (Iterable)((Iterable)RangesKt.downTo((int)(this.getAvailableUtilityBeltSize() - 1), (int)(this.selectedUtility + 1))));
        Iterator iterator = range.iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            if (!this.utilityBelt.get(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public final int getAvailableUtilityBeltSize() {
        return this.getDeepPocketsRowCount() > 0 || !GlobalSettings.utilityBeltShortDefaultSize.getBoolValue() ? 8 : 4;
    }

    @NotNull
    public final IntRange getAvailableDeepPocketsRange() {
        return RangeIteratorKt.expandBy(GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE.getFirst(), this.getDeepPocketsRowCount() * 9);
    }

    @NotNull
    public final IntRange getUnavailableDeepPocketsRange() {
        return new IntRange(this.getAvailableDeepPocketsRange().getLast() + 1, GeneralConstants.INVENTORY_ADDON_DEEP_POCKETS_RANGE.getLast());
    }

    public final int getDeepPocketsRowCount() {
        return RangesKt.coerceIn((int)class_1890.method_8203((class_1887)DeepPocketsEnchantment.INSTANCE, (class_1309)((class_1309)this.player)), (int)0, (int)3);
    }

    protected final boolean areItemsSimilar(@NotNull class_1799 stack1, @NotNull class_1799 stack2) {
        Intrinsics.checkNotNullParameter((Object)stack1, (String)"stack1");
        Intrinsics.checkNotNullParameter((Object)stack2, (String)"stack2");
        return RandomStuff.isNotEmpty(stack1) && stack1.method_7909() == stack2.method_7909() && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    @NotNull
    public final class_1799 findFittingToolBeltStack(@NotNull class_1799 sampleStack) {
        class_1799 class_17992;
        Intrinsics.checkNotNullParameter((Object)sampleStack, (String)"sampleStack");
        int index = this.findFittingToolBeltIndex(sampleStack);
        if (index == -1) {
            class_1799 class_17993 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"EMPTY");
            class_17992 = class_17993;
        } else {
            class_17992 = this.toolBelt.get(index);
        }
        return class_17992;
    }

    public final int findFittingToolBeltIndex(@NotNull class_1799 sampleStack) {
        Intrinsics.checkNotNullParameter((Object)sampleStack, (String)"sampleStack");
        Iterator<ToolBeltSlotTemplate> iterator = PlayerInventoryAddon.Companion.getToolBeltTemplates$inventorio().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            ToolBeltSlotTemplate template = iterator.next();
            if (!template.test(sampleStack, (PlayerInventoryAddon)this)) continue;
            return index;
        }
        return -1;
    }
}

