/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.lambdaurora.lambdynlights.LambDynLights;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public record ItemLightSource(class_2960 id, class_1792 item, int luminance, boolean waterSensitive) {
    public ItemLightSource(@NotNull class_2960 id, @NotNull class_1792 item, int luminance) {
        this(id, item, luminance, false);
    }

    public int getLuminance(@NotNull class_1799 stack, boolean submergedInWater) {
        if (this.waterSensitive && LambDynLights.get().config.hasWaterSensitiveCheck() && submergedInWater) {
            return 0;
        }
        return this.luminance;
    }

    @Override
    public String toString() {
        return "ItemLightSource{item=" + this.item + ", luminance=" + this.luminance + ", water_sensitive=" + this.waterSensitive + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Optional<ItemLightSource> fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
        int luminance;
        if (!json.has("item") || !json.has("luminance")) {
            LambDynLights.get().warn("Failed to parse item light source \"" + id + "\", invalid format: missing required fields.");
            return Optional.empty();
        }
        class_2960 affectId = new class_2960(json.get("item").getAsString());
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(affectId);
        if (item == class_1802.field_8162) {
            return Optional.empty();
        }
        JsonPrimitive luminanceElement = json.get("luminance").getAsJsonPrimitive();
        if (luminanceElement.isNumber()) {
            luminance = luminanceElement.getAsInt();
        } else if (luminanceElement.isString()) {
            String luminanceStr = luminanceElement.getAsString();
            if (luminanceStr.equals("block")) {
                class_1792 class_17922 = item;
                if (!(class_17922 instanceof class_1747)) return Optional.empty();
                class_1747 blockItem = (class_1747)class_17922;
                luminance = blockItem.method_7711().method_9564().method_26213();
            } else {
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(luminanceStr));
                if (block == class_2246.field_10124) {
                    return Optional.empty();
                }
                luminance = block.method_9564().method_26213();
            }
        } else {
            LambDynLights.get().warn("Failed to parse item light source \"" + id + "\", invalid format: \"luminance\" field value isn't string or integer.");
            return Optional.empty();
        }
        boolean waterSensitive = false;
        if (!json.has("water_sensitive")) return Optional.of(new ItemLightSource(id, item, luminance, waterSensitive));
        waterSensitive = json.get("water_sensitive").getAsBoolean();
        return Optional.of(new ItemLightSource(id, item, luminance, waterSensitive));
    }
}

