/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public final class ItemLightSources {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final List<ItemLightSource> ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();
    private static final List<ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new ArrayList<ItemLightSource>();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(@NotNull class_3300 resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.method_14488("dynamiclights/item", path -> path.endsWith(".json")).forEach(id -> ItemLightSources.load(resourceManager, id));
        ITEM_LIGHT_SOURCES.addAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(@NotNull class_3300 resourceManager, @NotNull class_2960 resourceId) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try {
            InputStream stream = resourceManager.method_14486(resourceId).method_14482();
            JsonObject json = JSON_PARSER.parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.contains(data)) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.get().warn("Failed to load item light source \"" + id + "\".");
        }
    }

    private static void register(@NotNull ItemLightSource data) {
        for (ItemLightSource other : ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + class_2378.field_11142.method_10221((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.add(data);
    }

    public static void registerItemLightSource(@NotNull ItemLightSource data) {
        for (ItemLightSource other : STATIC_ITEM_LIGHT_SOURCES) {
            if (other.item() != data.item()) continue;
            LambDynLights.get().warn("Failed to register item light source \"" + data.id() + "\", duplicates item \"" + class_2378.field_11142.method_10221((Object)data.item()) + "\" found in \"" + other.id() + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.add(data);
    }

    public static int getLuminance(@NotNull class_1799 stack, boolean submergedInWater) {
        for (ItemLightSource data : ITEM_LIGHT_SOURCES) {
            if (data.item() != stack.method_7909()) continue;
            return data.getLuminance(stack, submergedInWater);
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return blockItem.method_7711().method_9564().method_26213();
        }
        return 0;
    }
}

