/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.common.capability.AbstractRecipeData;

public class PlayerRecipeData
extends AbstractRecipeData<Player>
implements IPlayerRecipeData {
    public PlayerRecipeData(Player pOwner) {
        super(pOwner);
    }

    @Override
    public <T extends Recipe<C>, C extends Container> Optional<T> getRecipe(RecipeType<T> pType, C pInventory, Level pWorld, List<T> pRecipes) {
        Optional<T> maybeRecipe = super.getRecipe(pType, pInventory, pWorld, pRecipes);
        this.syncPlayerRecipeData();
        return maybeRecipe;
    }

    @Override
    public void selectRecipe(@Nonnull Recipe<?> pRecipe) {
        super.selectRecipe(pRecipe);
        this.syncPlayerRecipeData();
    }

    private void syncPlayerRecipeData() {
        if (this.getOwner() instanceof ServerPlayer) {
            PolymorphApi.common().getPacketDistributor().sendPlayerSyncS2C((ServerPlayer)this.getOwner(), this.getRecipesList(), this.getSelectedRecipe().map(Recipe::m_6423_).orElse(null));
        }
    }

    @Override
    public Set<ServerPlayer> getListeners() {
        Player player = (Player)this.getOwner();
        if (player instanceof ServerPlayer) {
            return Collections.singleton((ServerPlayer)player);
        }
        return new HashSet<ServerPlayer>();
    }
}

