/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.api.common.base.IPolymorphPacketDistributor;
import top.theillusivec4.polymorph.api.common.capability.IBlockEntityRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IPlayerRecipeData;
import top.theillusivec4.polymorph.api.common.capability.IStackRecipeData;
import top.theillusivec4.polymorph.common.capability.PolymorphCapabilities;
import top.theillusivec4.polymorph.common.impl.PolymorphPacketDistributor;

public class PolymorphCommon
implements IPolymorphCommon {
    private static final IPolymorphCommon INSTANCE = new PolymorphCommon();
    private final List<IPolymorphCommon.ITileEntity2RecipeData> tileEntity2RecipeData = new LinkedList<IPolymorphCommon.ITileEntity2RecipeData>();
    private final List<IPolymorphCommon.IContainer2TileEntity> container2TileEntities = new LinkedList<IPolymorphCommon.IContainer2TileEntity>();
    private final List<IPolymorphCommon.IContainer2ItemStack> container2ItemStacks = new LinkedList<IPolymorphCommon.IContainer2ItemStack>();
    private final List<IPolymorphCommon.IItemStack2RecipeData> itemStack2RecipeData = new LinkedList<IPolymorphCommon.IItemStack2RecipeData>();
    private final IPolymorphPacketDistributor distributor = new PolymorphPacketDistributor();
    private MinecraftServer server = null;

    public static IPolymorphCommon get() {
        return INSTANCE;
    }

    @Override
    public IPolymorphPacketDistributor getPacketDistributor() {
        return this.distributor;
    }

    @Override
    public void setServer(MinecraftServer pServer) {
        this.server = pServer;
    }

    @Override
    public Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(this.server);
    }

    @Override
    public Optional<IBlockEntityRecipeData> tryCreateRecipeData(BlockEntity pTileEntity) {
        for (IPolymorphCommon.ITileEntity2RecipeData function : this.tileEntity2RecipeData) {
            IBlockEntityRecipeData recipeData = function.createRecipeData(pTileEntity);
            if (recipeData == null) continue;
            return Optional.of(recipeData);
        }
        return Optional.empty();
    }

    @Override
    public LazyOptional<IBlockEntityRecipeData> getRecipeData(BlockEntity pTileEntity) {
        return PolymorphCapabilities.getRecipeData(pTileEntity);
    }

    @Override
    public LazyOptional<IBlockEntityRecipeData> getRecipeDataFromTileEntity(AbstractContainerMenu pContainer) {
        for (IPolymorphCommon.IContainer2TileEntity function : this.container2TileEntities) {
            BlockEntity tileEntity = function.getTileEntity(pContainer);
            if (tileEntity == null) continue;
            return this.getRecipeData(tileEntity);
        }
        return LazyOptional.empty();
    }

    @Override
    public Optional<IStackRecipeData> tryCreateRecipeData(ItemStack pStack) {
        for (IPolymorphCommon.IItemStack2RecipeData function : this.itemStack2RecipeData) {
            IStackRecipeData recipeData = function.createRecipeData(pStack);
            if (recipeData == null) continue;
            return Optional.of(recipeData);
        }
        return Optional.empty();
    }

    @Override
    public LazyOptional<IStackRecipeData> getRecipeData(ItemStack pStack) {
        return PolymorphCapabilities.getRecipeData(pStack);
    }

    @Override
    public LazyOptional<IStackRecipeData> getRecipeDataFromItemStack(AbstractContainerMenu pContainer) {
        for (IPolymorphCommon.IContainer2ItemStack function : this.container2ItemStacks) {
            ItemStack itemstack = function.getItemStack(pContainer);
            if (itemstack.m_41619_()) continue;
            return this.getRecipeData(itemstack);
        }
        return LazyOptional.empty();
    }

    @Override
    public LazyOptional<IPlayerRecipeData> getRecipeData(Player pPlayer) {
        return PolymorphCapabilities.getRecipeData(pPlayer);
    }

    @Override
    public void registerTileEntity2RecipeData(IPolymorphCommon.ITileEntity2RecipeData pTileEntity2PersistentDataset) {
        this.tileEntity2RecipeData.add(pTileEntity2PersistentDataset);
    }

    @Override
    public void registerContainer2TileEntity(IPolymorphCommon.IContainer2TileEntity pContainer2TileEntity) {
        this.container2TileEntities.add(pContainer2TileEntity);
    }

    @Override
    public void registerItemStack2RecipeData(IPolymorphCommon.IItemStack2RecipeData pItemStack2RecipeData) {
        this.itemStack2RecipeData.add(pItemStack2RecipeData);
    }

    @Override
    public void registerContainer2ItemStack(IPolymorphCommon.IContainer2ItemStack pContainer2ItemStack) {
        this.container2ItemStacks.add(pContainer2ItemStack);
    }
}

