/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.client.recipe.RecipesWidget;

@JeiPlugin
public class JeiModule
implements IModPlugin {
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new PolymorphContainer());
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("polymorph", "jei");
    }

    public static void selectRecipe(Object recipe) {
        if (recipe instanceof Recipe) {
            PolymorphApi.common().getPacketDistributor().sendPlayerRecipeSelectionC2S(((Recipe)recipe).m_6423_());
        }
    }

    private static class PolymorphContainer
    implements IGlobalGuiHandler {
        private PolymorphContainer() {
        }

        @Nonnull
        public List<Rect2i> getGuiExtraAreas() {
            ArrayList<Rect2i> list = new ArrayList<Rect2i>();
            RecipesWidget.get().ifPresent(widget -> {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof AbstractContainerScreen && widget.getSelectionWidget().isActive()) {
                    AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                    int x = containerScreen.getGuiLeft() + widget.getXPos();
                    int y = containerScreen.getGuiTop() + widget.getYPos();
                    int size = widget.getSelectionWidget().getOutputWidgets().size();
                    int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
                    if (size % 2 == 0) {
                        xOffset += 13;
                    }
                    x = x + -4 + xOffset;
                    list.add(new Rect2i(x, y += -26, 25 * size, 25));
                }
            });
            return list;
        }
    }
}

