/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;

public class CPacketStackRecipeSelection {
    private final ResourceLocation recipe;

    public CPacketStackRecipeSelection(ResourceLocation pResourceLocation) {
        this.recipe = pResourceLocation;
    }

    public static void encode(CPacketStackRecipeSelection pPacket, FriendlyByteBuf pBuffer) {
        pBuffer.m_130085_(pPacket.recipe);
    }

    public static CPacketStackRecipeSelection decode(FriendlyByteBuf pBuffer) {
        return new CPacketStackRecipeSelection(pBuffer.m_130281_());
    }

    public static void handle(CPacketStackRecipeSelection pPacket, Supplier<NetworkEvent.Context> pContext) {
        pContext.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)pContext.get()).getSender();
            if (sender != null) {
                Level world = sender.m_20193_();
                Optional maybeRecipe = world.m_7465_().m_44043_(pPacket.recipe);
                maybeRecipe.ifPresent(recipe -> {
                    AbstractContainerMenu container = sender.f_36096_;
                    PolymorphApi.common().getRecipeDataFromItemStack(container).ifPresent(recipeData -> {
                        recipeData.selectRecipe((Recipe<?>)recipe);
                        for (AbstractCompatibilityModule integration : PolymorphIntegrations.get()) {
                            if (!integration.selectRecipe(container, (Recipe<?>)recipe)) continue;
                            return;
                        }
                    });
                });
            }
        });
        pContext.get().setPacketHandled(true);
    }
}

