/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityFunctions {
    public static Boolean isHorse(Entity entity) {
        if (entity instanceof AbstractHorse) {
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(String entitystring) {
        String type = entitystring.split("\\[")[0];
        for (String moddedvillager : GlobalVariables.moddedvillagers) {
            if (!type.equalsIgnoreCase(moddedvillager)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModdedVillager(Entity entity) {
        String entitystring = EntityFunctions.getEntityString(entity);
        return EntityFunctions.isModdedVillager(entitystring);
    }

    public static boolean isMilkable(Entity entity) {
        if (entity instanceof Sheep || entity instanceof Llama || entity instanceof Pig || entity instanceof Donkey || entity instanceof Horse || entity instanceof Mule) {
            if (!(entity instanceof Animal)) {
                return false;
            }
            Animal animal = (Animal)entity;
            return !animal.m_6162_();
        }
        return false;
    }

    public static String getEntityString(Entity entity) {
        String entitystring = "";
        try {
            entitystring = entity.toString();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return entitystring;
    }

    public static void nameEntity(Entity entity, String name) {
        if (name != "") {
            entity.m_6593_((Component)new TextComponent(name));
        }
    }

    public static void addPotionEffect(Entity entity, MobEffect effect, Integer ms) {
        MobEffectInstance freeze = new MobEffectInstance(effect, ms / 50);
        LivingEntity le = (LivingEntity)entity;
        le.m_7292_(freeze);
    }

    public static void removePotionEffect(Entity entity, MobEffect effect) {
        LivingEntity le = (LivingEntity)entity;
        le.m_21195_(effect);
    }

    public static void chargeEntity(Entity entity) {
        Level world = entity.m_20193_();
        Vec3 evec = entity.m_20182_();
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, world);
        lightning.m_6034_(evec.m_7096_(), evec.m_7098_(), evec.m_7094_());
        lightning.m_20084_(new UUID(0L, GlobalVariables.random.nextInt() * 1000000));
        entity.m_8038_((ServerLevel)world, lightning);
        entity.m_20095_();
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to, boolean ignoremainhand) {
        if (!(from instanceof Mob)) {
            return;
        }
        Mob mobfrom = (Mob)from;
        for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
            ItemStack itemstack;
            if (ignoremainhand && equipmentslottype.equals((Object)EquipmentSlot.MAINHAND) || (itemstack = mobfrom.m_6844_(equipmentslottype)).m_41619_()) continue;
            to.m_8061_(equipmentslottype, itemstack.m_41777_());
        }
    }

    public static void transferItemsBetweenEntities(Entity from, Entity to) {
        EntityFunctions.transferItemsBetweenEntities(from, to, false);
    }

    public static Boolean doesEntitySurviveThisDamage(Player player, int halfheartdamage) {
        return EntityFunctions.doesEntitySurviveThisDamage((LivingEntity)player, halfheartdamage);
    }

    public static Boolean doesEntitySurviveThisDamage(LivingEntity entity, int halfheartdamage) {
        float newhealth = entity.m_21223_() - (float)halfheartdamage;
        if (!(newhealth > 0.0f)) {
            entity.m_6469_(DamageSource.f_19319_, Float.MAX_VALUE);
            return false;
        }
        entity.m_6469_(DamageSource.f_19319_, 0.1f);
        entity.m_21153_(newhealth);
        return true;
    }
}

