/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective.functions.NumberFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PlayerFunctions {
    public static boolean respawnPlayer(Level world, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        MinecraftServer server = world.m_142572_();
        ServerPlayer serverplayer = (ServerPlayer)player;
        if (serverplayer.f_8944_) {
            serverplayer.f_8944_ = false;
            serverplayer = server.m_6846_().m_11236_(serverplayer, true);
            CriteriaTriggers.f_10588_.m_19757_(serverplayer, Level.f_46430_, Level.f_46428_);
        } else if (serverplayer.m_21223_() <= 0.0f) {
            serverplayer = server.m_6846_().m_11236_(serverplayer, false);
        }
        return true;
    }

    public static Player matchPlayer(Player player, String other) {
        return PlayerFunctions.matchPlayer(player.m_20193_(), other);
    }

    public static Player matchPlayer(Level world, String other) {
        List players = world.m_6907_();
        for (Player onlineplayer : players) {
            if (!onlineplayer.m_7755_().getString().toLowerCase().equals(other)) continue;
            return onlineplayer;
        }
        return null;
    }

    public static boolean isHoldingWater(Player player) {
        return player.m_21120_(InteractionHand.OFF_HAND).m_41720_().equals(Items.f_42447_) || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(Items.f_42447_);
    }

    public static boolean isJoiningWorldForTheFirstTime(Player player, String modid) {
        String firstjointag = "collective.firstJoin." + modid;
        Set tags = player.m_19880_();
        if (tags.contains(firstjointag)) {
            return false;
        }
        player.m_20049_(firstjointag);
        Inventory inv = player.m_150109_();
        boolean isempty = true;
        for (int i = 0; i < 36; ++i) {
            if (inv.m_8020_(i).m_41619_()) continue;
            isempty = false;
            break;
        }
        if (!isempty) {
            return false;
        }
        Level world = player.m_20193_();
        ServerLevel ServerLevel2 = (ServerLevel)world;
        BlockPos wspos = ServerLevel2.m_8900_();
        BlockPos ppos = player.m_142538_();
        BlockPos cpos = new BlockPos(ppos.m_123341_(), wspos.m_123342_(), ppos.m_123343_());
        return cpos.m_123314_((Vec3i)wspos, 50.0);
    }

    public static BlockPos getSpawnPoint(Level world, Player player) {
        Vec3 spawnvec = PlayerFunctions.getSpawnVec(world, player);
        return new BlockPos(spawnvec.f_82479_, spawnvec.f_82480_, spawnvec.f_82481_);
    }

    public static Vec3 getSpawnVec(Level world, Player player) {
        Optional optionalbed;
        ServerPlayer serverplayer = (ServerPlayer)player;
        ServerLevel ServerLevel2 = (ServerLevel)world;
        BlockPos respawnlocation = ServerLevel2.m_8900_();
        Vec3 respawnvec = new Vec3((double)respawnlocation.m_123341_(), (double)respawnlocation.m_123342_(), (double)respawnlocation.m_123343_());
        BlockPos bedpos = serverplayer.m_8961_();
        if (bedpos != null && (optionalbed = Player.m_36130_((ServerLevel)ServerLevel2, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)) != null && optionalbed.isPresent()) {
            Vec3 bedvec = (Vec3)optionalbed.get();
            BlockPos bp = new BlockPos(bedvec);
            Iterator it = BlockPos.m_121886_((int)(bp.m_123341_() - 1), (int)(bp.m_123342_() - 1), (int)(bp.m_123343_() - 1), (int)(bp.m_123341_() + 1), (int)(bp.m_123342_() + 1), (int)(bp.m_123343_() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos np = (BlockPos)it.next();
                BlockState state = world.m_8055_(np);
                Block block = state.m_60734_();
                if (!(block instanceof BedBlock)) continue;
                respawnvec = bedvec;
                break;
            }
        }
        return respawnvec;
    }

    public static String getPlayerGearString(Player player) {
        Object skconfig = "";
        ItemStack offhand = player.m_6844_(EquipmentSlot.OFFHAND);
        if (!offhand.m_41619_()) {
            CompoundTag nbt = new CompoundTag();
            nbt = offhand.m_41739_(nbt);
            String nbtstring = nbt.toString();
            skconfig = (String)skconfig + "'offhand' : '" + nbtstring + "',";
        } else {
            skconfig = (String)skconfig + "'offhand' : '',";
        }
        ItemStack head = player.m_6844_(EquipmentSlot.HEAD);
        if (!head.m_41619_()) {
            CompoundTag nbt = new CompoundTag();
            nbt = head.m_41739_(nbt);
            String nbtstring = nbt.toString();
            skconfig = (String)skconfig + "\n'head' : '" + nbtstring + "',";
        } else {
            skconfig = (String)skconfig + "\n'head' : '',";
        }
        ItemStack chest = player.m_6844_(EquipmentSlot.CHEST);
        if (!chest.m_41619_()) {
            CompoundTag nbt = new CompoundTag();
            nbt = chest.m_41739_(nbt);
            String nbtstring = nbt.toString();
            skconfig = (String)skconfig + "\n'chest' : '" + nbtstring + "',";
        } else {
            skconfig = (String)skconfig + "\n'chest' : '',";
        }
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        if (!legs.m_41619_()) {
            CompoundTag nbt = new CompoundTag();
            nbt = legs.m_41739_(nbt);
            String nbtstring = nbt.toString();
            skconfig = (String)skconfig + "\n'legs' : '" + nbtstring + "',";
        } else {
            skconfig = (String)skconfig + "\n'legs' : '',";
        }
        ItemStack feet = player.m_6844_(EquipmentSlot.FEET);
        if (!feet.m_41619_()) {
            CompoundTag nbt = new CompoundTag();
            nbt = feet.m_41739_(nbt);
            String nbtstring = nbt.toString();
            skconfig = (String)skconfig + "\n'feet' : '" + nbtstring + "',";
        } else {
            skconfig = (String)skconfig + "\n'feet' : '',";
        }
        Inventory inv = player.m_150109_();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inv.m_8020_(i);
            if (!slot.m_41619_()) {
                CompoundTag nbt = new CompoundTag();
                nbt = slot.m_41739_(nbt);
                String nbtstring = nbt.toString();
                skconfig = (String)skconfig + "\n" + i + " : '" + nbtstring + "',";
                continue;
            }
            skconfig = (String)skconfig + "\n" + i + " : '',";
        }
        return skconfig;
    }

    public static String getPlayerGearStringFromHashMap(HashMap<String, ItemStack> gear) {
        CompoundTag nbt;
        Object gearstring = "";
        ArrayList<String> specialslots = new ArrayList<String>(Arrays.asList("offhand", "head", "chest", "legs", "feet"));
        for (String specialslot : specialslots) {
            String specialslotstring = "";
            if (gear.containsKey(specialslot)) {
                nbt = new CompoundTag();
                nbt = gear.get(specialslot).m_41739_(nbt);
                specialslotstring = nbt.toString();
            }
            if (gearstring != "") {
                gearstring = (String)gearstring + "\n";
            }
            gearstring = (String)gearstring + "'" + specialslot + "' : '" + specialslotstring + "',";
        }
        NonNullList emptyinventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
        for (int i = 0; i < emptyinventory.size(); ++i) {
            String itemstring = "";
            if (gear.containsKey("" + i)) {
                nbt = new CompoundTag();
                nbt = gear.get("" + i).m_41739_(nbt);
                itemstring = nbt.toString();
            }
            gearstring = (String)gearstring + "\n" + i + " : '" + itemstring + "',";
        }
        return gearstring;
    }

    public static void setPlayerGearFromString(Player player, String gearconfig) {
        String[] gearspl = gearconfig.split("\n");
        int newlinecount = gearspl.length;
        if (newlinecount < 40) {
            System.out.println("[Error] setPlayerGearFromString: The gear config does not contain 40 lines and is invalid.");
            return;
        }
        boolean cleared = false;
        for (String line : gearspl) {
            String[] lspl;
            if ((line = line.trim().replaceAll("\n", "")).endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            if ((lspl = line.split(" : ")).length != 2) {
                System.out.println("[Error] setPlayerGearFromString: The line '" + line + "' is invalid.");
                return;
            }
            String slotstring = lspl[0].replace("'", "");
            String data = lspl[1];
            if ((data = data.substring(1, data.length() - 1)).length() < 2) continue;
            ItemStack itemstack = null;
            try {
                CompoundTag newnbt = TagParser.m_129359_((String)data);
                itemstack = ItemStack.m_41712_((CompoundTag)newnbt);
            }
            catch (CommandSyntaxException newnbt) {
                // empty catch block
            }
            if (itemstack == null) {
                System.out.println("[Error] setPlayerGearFromString: Unable to get the correct itemstack data from '" + line + "'.");
                return;
            }
            if (!cleared) {
                cleared = true;
                player.m_150109_().m_6211_();
            }
            if (NumberFunctions.isNumeric(slotstring)) {
                int slot = Integer.parseInt(slotstring);
                player.m_150109_().m_6836_(slot, itemstack);
                continue;
            }
            EquipmentSlot type = null;
            if (slotstring.equals("offhand")) {
                type = EquipmentSlot.OFFHAND;
            } else if (slotstring.equals("head")) {
                type = EquipmentSlot.HEAD;
            } else if (slotstring.equals("chest")) {
                type = EquipmentSlot.CHEST;
            } else if (slotstring.equals("legs")) {
                type = EquipmentSlot.LEGS;
            } else {
                if (!slotstring.equals("feet")) continue;
                type = EquipmentSlot.FEET;
            }
            if (type == null) continue;
            player.m_8061_(type, itemstack);
        }
    }
}

