/*
 * Decompiled with CFR 0.152.
 */
package com.loucaskreger.searchablecontainers.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.loucaskreger.searchablecontainers.config.ConfigInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    private static final File configFolder = new File("config");
    private static File configFile;
    private static final Gson gson;
    public static ConfigInstance INSTANCE;

    public static void init() {
        Config.load();
        Config.genFile();
        Config.read();
        Config.write();
    }

    private static void load() {
        INSTANCE = new ConfigInstance();
    }

    private static void genFile() {
        if (!configFolder.exists()) {
            configFolder.mkdir();
        }
        if (configFolder.isDirectory()) {
            configFile = new File(configFolder, "searchablecontainers.json");
            if (!configFile.exists()) {
                try {
                    configFile.createNewFile();
                    Config.load();
                    String config = gson.toJson((Object)INSTANCE);
                    FileWriter writer = new FileWriter(configFile);
                    writer.write(config);
                    writer.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't create config file", e);
                }
            } else if (configFile.isDirectory()) {
                throw new IllegalStateException("'searchablecontainers.json' must be a file not a directory.");
            }
        } else {
            throw new IllegalStateException("'config' must be a folder!");
        }
    }

    private static void read() {
        try {
            INSTANCE = (ConfigInstance)gson.fromJson((Reader)new FileReader(configFile), ConfigInstance.class);
            if (INSTANCE == null) {
                throw new IllegalStateException("Null configuration");
            }
        }
        catch (JsonSyntaxException e) {
            System.err.println("JSON error, invalid syntax.");
            e.printStackTrace();
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void write() {
        try {
            String json = gson.toJson((Object)INSTANCE);
            FileWriter writer = new FileWriter(configFile, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't update config file", e);
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

