/*
 * Decompiled with CFR 0.152.
 */
package com.loucaskreger.searchablecontainers.mixin;

import com.loucaskreger.searchablecontainers.SearchableContainers;
import com.loucaskreger.searchablecontainers.config.Config;
import com.loucaskreger.searchablecontainers.mixin.HandledScreenAccessor;
import com.loucaskreger.searchablecontainers.widget.ArrowButtonWidget;
import com.loucaskreger.searchablecontainers.widget.SmartTextField;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public class HandledScreenMixin
extends class_437 {
    private static final class_310 mc = class_310.method_1551();
    private static final int BUTTON_PADDING = 5;
    private static final int COLOR = -1879048192;
    private static final int PLAYER_INVENTORY_INDEX_SIZE = 35;
    private SmartTextField textField;
    private ArrowButtonWidget toInventoryButton;
    private class_4185.class_5316 toInventoryTooltipSupplier = (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, Arrays.asList(new class_2585("Moves items from container").method_30937(), new class_2585(" to the players inventory").method_30937()), mouseX, mouseY);
    private ArrowButtonWidget toContainerButton;
    private class_4185.class_5316 toContainerTooltipSupplier = (button, matrices, mouseX, mouseY) -> this.method_25417(matrices, Arrays.asList(new class_2585("Moves items from the player's").method_30937(), new class_2585("inventory to the open container").method_30937()), mouseX, mouseY);
    private HandledScreenAccessor accessor;

    protected HandledScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"}, cancellable=true)
    private void onInit(CallbackInfo ci) {
        this.accessor = (HandledScreenAccessor)((Object)this);
        boolean isCreativeScreen = this instanceof class_481;
        boolean isInventoryScreen = this instanceof class_485;
        int x = this.accessor.getContainerX() + this.accessor.getBackgroundWidth() / 2 - 50;
        int y = this.accessor.getContainerY() - 11 - Config.INSTANCE.verticalPadding;
        if (!isCreativeScreen) {
            this.textField = new SmartTextField(HandledScreenMixin.mc.field_1772, x, y, (class_2561)new class_2585(SmartTextField.currentText));
            this.textField.method_1863(this::textFieldChanged);
            this.method_37063((class_364)this.textField);
        }
        if (!isInventoryScreen) {
            this.toInventoryButton = new ArrowButtonWidget(x + 101 + 5, y, this::toInventoryButtonPressed, ArrowButtonWidget.Orientation.DOWN, Config.INSTANCE.showButtonTooltips ? this.toInventoryTooltipSupplier : class_4185.field_25035);
            this.toContainerButton = new ArrowButtonWidget(x + 101 + 23, y, this::toContainerButtonPressed, ArrowButtonWidget.Orientation.UP, Config.INSTANCE.showButtonTooltips ? this.toContainerTooltipSupplier : class_4185.field_25035);
            this.method_37063((class_364)this.toInventoryButton);
            this.method_37063((class_364)this.toContainerButton);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render"})
    public void render(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_2371 slots = ((class_465)this).method_17577().field_7761;
        for (class_1735 slot : slots) {
            if (this.textField == null || SmartTextField.currentText.equals("") || this.stackMatches(this.textField.method_1882(), slot.method_7677())) continue;
            int x = slot.field_7873 + this.accessor.getContainerX();
            int y = slot.field_7872 + this.accessor.getContainerY();
            RenderSystem.disableDepthTest();
            class_332.method_25294((class_4587)matrices, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)-1879048192);
            RenderSystem.enableDepthTest();
        }
    }

    private void textFieldChanged(String text) {
        SmartTextField.currentText = text;
    }

    private void toInventoryButtonPressed(class_4185 button) {
        class_636 interactionManager = HandledScreenMixin.mc.field_1761;
        class_746 player = HandledScreenMixin.mc.field_1724;
        class_2371 slots = ((class_465)this).method_17577().field_7761;
        for (int i = 0; i < slots.size() - 35; ++i) {
            if (this.textField == null || SmartTextField.currentText.equals("") || !this.stackMatches(this.textField.method_1882(), ((class_1735)slots.get(i)).method_7677())) continue;
            interactionManager.method_2906(((class_465)this).method_17577().field_7763, i, 0, class_1713.field_7794, (class_1657)player);
        }
    }

    private void toContainerButtonPressed(class_4185 button) {
        class_636 interactionManager = HandledScreenMixin.mc.field_1761;
        class_746 player = HandledScreenMixin.mc.field_1724;
        class_2371 slots = ((class_465)this).method_17577().field_7761;
        for (int i = slots.size() - 1 - 35; i < slots.size(); ++i) {
            if (this.textField == null || SmartTextField.currentText.equals("") || !this.stackMatches(this.textField.method_1882(), ((class_1735)slots.get(i)).method_7677())) continue;
            interactionManager.method_2906(((class_465)this).method_17577().field_7763, i, 0, class_1713.field_7794, (class_1657)player);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed"}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> ci) {
        if (this.textField != null) {
            if (keyCode == 69 && this.textField.method_25370()) {
                ci.cancel();
            }
            if (keyCode == SearchableContainers.HIDE_KEY.method_1429().method_1444() && modifiers == 2 && !this.textField.method_25370()) {
                SmartTextField.isVisible = !SmartTextField.isVisible;
                this.textField.method_1862(SmartTextField.isVisible);
            }
        }
    }

    public boolean stackMatches(String text, class_1799 stack) {
        if (stack.method_7909().equals(class_1802.field_8162)) {
            return false;
        }
        if (stack.method_7909().equals(class_1802.field_8162) && text.equals("")) {
            return true;
        }
        ArrayList<String> keys = new ArrayList<String>();
        List tooltip = stack.method_7950((class_1657)HandledScreenMixin.mc.field_1724, (class_1836)(HandledScreenMixin.mc.field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934));
        if (!Config.INSTANCE.searchTooltips) {
            keys.add(((class_2561)tooltip.get(0)).getString());
        } else {
            for (class_2561 line : tooltip) {
                keys.add(line.getString());
            }
        }
        for (String key : keys) {
            if (!key.toLowerCase(Locale.ROOT).contains(text.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }
}

