/*
 * Decompiled with CFR 0.152.
 */
package net.skinchange.mixin;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.HashMap;
import net.minecraft.class_1071;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1071.class})
public abstract class MixinPlayerSkinProvider {
    @Accessor(value="sessionService")
    public abstract MinecraftSessionService getSessionService();

    @Inject(at={@At(value="HEAD")}, method={"loadSkin(Lcom/mojang/authlib/GameProfile;Lnet/minecraft/client/texture/PlayerSkinProvider$SkinTextureAvailableCallback;Z)V"})
    private void loadSkin(GameProfile profile, class_1071.class_1072 callback, boolean requireSecure, CallbackInfo ci) {
        HashMap map = Maps.newHashMap();
        try {
            map.putAll(this.getSessionService().getTextures(profile, requireSecure));
        }
        catch (InsecureTextureException insecureTextureException) {
            // empty catch block
        }
        if (map.isEmpty()) {
            this.getSessionService().fillProfileProperties(profile, requireSecure);
        }
    }
}

