/*
 * Decompiled with CFR 0.152.
 */
package lazy.snad.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lazy.snad.ConfigPathPlatformExpect;

public class ModConfigs {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = ConfigPathPlatformExpect.getConfigDirectory();
    public static final String FULL_PATH = CONFIG_PATH.toString() + "/snad_config.json";
    private int speed = 2;

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    private static ModConfigs load() {
        ModConfigs config = new ModConfigs();
        try {
            ModConfigs.checkExistence();
            config = (ModConfigs)GSON.fromJson((Reader)new FileReader(FULL_PATH), ModConfigs.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static ModConfigs get() {
        ModConfigs config = ModConfigs.load();
        if (config.speed < 1) {
            config.speed = 1;
        }
        return config;
    }

    public static void save(ModConfigs config) {
        try {
            ModConfigs.checkExistence();
            FileWriter writer = new FileWriter(FULL_PATH);
            GSON.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void checkExistence() throws IOException {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        if (!Files.exists(Paths.get(FULL_PATH, new String[0]), new LinkOption[0])) {
            Files.createFile(Paths.get(FULL_PATH, new String[0]), new FileAttribute[0]);
            ModConfigs.save(new ModConfigs());
        }
    }
}

