/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.ChatEvent;
import dev.architectury.event.events.common.ChunkEvent;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.value.IntValue;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.TextFilter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppingEvent;

public class EventHandlerImplCommon {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TickEvent.SERVER_PRE.invoker().tick(ServerLifecycleHooks.getCurrentServer());
        } else if (event.phase == TickEvent.Phase.END) {
            TickEvent.SERVER_POST.invoker().tick(ServerLifecycleHooks.getCurrentServer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START) {
                TickEvent.SERVER_LEVEL_PRE.invoker().tick((ServerLevel)event.world);
            } else if (event.phase == TickEvent.Phase.END) {
                TickEvent.SERVER_LEVEL_POST.invoker().tick((ServerLevel)event.world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStartingEvent event) {
        LifecycleEvent.SERVER_STARTING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStartedEvent event) {
        LifecycleEvent.SERVER_STARTED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStoppingEvent event) {
        LifecycleEvent.SERVER_STOPPING.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerStoppedEvent event) {
        LifecycleEvent.SERVER_STOPPED.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(RegisterCommandsEvent event) {
        CommandRegistrationEvent.EVENT.invoker().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getEnvironment());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEvent.PLAYER_JOIN.invoker().join((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEvent.PLAYER_QUIT.invoker().quit((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEvent.PLAYER_RESPAWN.invoker().respawn((ServerPlayer)event.getPlayer(), event.isEndConquered());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(CommandEvent event) {
        CommandPerformEvent performEvent = new CommandPerformEvent((ParseResults<CommandSourceStack>)event.getParseResults(), event.getException());
        if (CommandPerformEvent.EVENT.invoker().act(performEvent).isFalse()) {
            event.setCanceled(true);
        }
        event.setParseResults(performEvent.getResults());
        event.setException(performEvent.getThrowable());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TickEvent.PLAYER_PRE.invoker().tick(event.player);
        } else if (event.phase == TickEvent.Phase.END) {
            TickEvent.PLAYER_POST.invoker().tick(event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ServerChatEvent event) {
        class ChatComponentImpl
        implements ChatEvent.ChatComponent {
            final /* synthetic */ ServerChatEvent val$event;

            ChatComponentImpl(ServerChatEvent serverChatEvent) {
                this.val$event = serverChatEvent;
            }

            @Override
            public Component getRaw() {
                return new TextComponent(this.val$event.getMessage());
            }

            @Override
            public Component getFiltered() {
                return this.val$event.getComponent();
            }

            @Override
            public void setRaw(Component raw) {
            }

            @Override
            public void setFiltered(Component filtered) {
                this.val$event.setComponent(filtered);
            }
        }
        EventResult process = ChatEvent.SERVER.invoker().process(event.getPlayer(), TextFilter.FilteredText.m_143720_((String)event.getMessage()), new ChatComponentImpl(event));
        if (process.isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getWorld();
            LifecycleEvent.SERVER_LEVEL_LOAD.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getWorld();
            LifecycleEvent.SERVER_LEVEL_UNLOAD.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(WorldEvent.Save event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getWorld();
            LifecycleEvent.SERVER_LEVEL_SAVE.invoker().act(world);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingDeathEvent event) {
        if (EntityEvent.LIVING_DEATH.invoker().die(event.getEntityLiving(), event.getSource()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AdvancementEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            PlayerEvent.PLAYER_ADVANCEMENT.invoker().award((ServerPlayer)event.getPlayer(), event.getAdvancement());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.Clone event) {
        if (event.getOriginal() instanceof ServerPlayer && event.getPlayer() instanceof ServerPlayer) {
            PlayerEvent.PLAYER_CLONE.invoker().clone((ServerPlayer)event.getOriginal(), (ServerPlayer)event.getPlayer(), !event.isWasDeath());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Start event) {
        if (ExplosionEvent.PRE.invoker().explode(event.getWorld(), event.getExplosion()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ExplosionEvent.Detonate event) {
        ExplosionEvent.DETONATE.invoker().explode(event.getWorld(), event.getExplosion(), event.getAffectedEntities());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingAttackEvent event) {
        if (EntityEvent.LIVING_HURT.invoker().hurt(event.getEntityLiving(), event.getSource(), event.getAmount()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityJoinWorldEvent event) {
        if (EntityEvent.ADD.invoker().add(event.getEntity(), event.getWorld()).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.FarmlandTrampleEvent event) {
        if (InteractionEvent.FARMLAND_TRAMPLE.invoker().trample((Level)event.getWorld(), event.getPos(), event.getState(), event.getFallDistance(), event.getEntity()).value() != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FillBucketEvent event) {
        ItemStack oldItem = event.getEmptyBucket();
        CompoundEventResult<ItemStack> result = PlayerEvent.FILL_BUCKET.invoker().fill(event.getPlayer(), event.getWorld(), oldItem, event.getTarget());
        if (result.interruptsFurtherEvaluation()) {
            event.setCanceled(true);
            event.setFilledBucket(result.object());
            if (result.value() != null) {
                event.setResult(result.value() != false ? Event.Result.ALLOW : Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(LivingSpawnEvent.CheckSpawn event) {
        EventResult result = EntityEvent.LIVING_CHECK_SPAWN.invoker().canSpawn(event.getEntityLiving(), event.getWorld(), event.getX(), event.getY(), event.getZ(), event.getSpawnReason(), event.getSpawner());
        if (result.interruptsFurtherEvaluation()) {
            if (result.value() != null) {
                event.setResult(result.value() == Boolean.TRUE ? Event.Result.ALLOW : Event.Result.DENY);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(AnimalTameEvent event) {
        EventResult result = EntityEvent.ANIMAL_TAME.invoker().tame(event.getAnimal(), event.getTamer());
        event.setCanceled(result.isFalse());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemCraftedEvent event) {
        PlayerEvent.CRAFT_ITEM.invoker().craft(event.getPlayer(), event.getCrafting(), event.getInventory());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemSmeltedEvent event) {
        PlayerEvent.SMELT_ITEM.invoker().smelt(event.getPlayer(), event.getSmelting());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(EntityItemPickupEvent event) {
        PlayerEvent.PICKUP_ITEM_PRE.invoker().canPickup(event.getPlayer(), event.getItem(), event.getItem().m_32055_());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.ItemPickupEvent event) {
        PlayerEvent.PICKUP_ITEM_POST.invoker().pickup(event.getPlayer(), event.getOriginalEntity(), event.getStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ItemTossEvent event) {
        PlayerEvent.DROP_ITEM.invoker().drop(event.getPlayer(), event.getEntityItem());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Open event) {
        PlayerEvent.OPEN_MENU.invoker().open(event.getPlayer(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerContainerEvent.Close event) {
        PlayerEvent.CLOSE_MENU.invoker().close(event.getPlayer(), event.getContainer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickItem event) {
        CompoundEventResult<ItemStack> result = InteractionEvent.RIGHT_CLICK_ITEM.invoker().click(event.getPlayer(), event.getHand());
        if (result.isPresent()) {
            event.setCanceled(true);
            event.setCancellationResult(result.result().asMinecraft());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.RightClickBlock event) {
        EventResult result = InteractionEvent.RIGHT_CLICK_BLOCK.invoker().click(event.getPlayer(), event.getHand(), event.getPos(), event.getFace());
        if (result.isPresent()) {
            event.setCanceled(true);
            event.setCancellationResult(result.asMinecraft());
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.EntityInteract event) {
        EventResult result = InteractionEvent.INTERACT_ENTITY.invoker().interact(event.getPlayer(), event.getTarget(), event.getHand());
        if (result.isPresent()) {
            event.setCanceled(true);
            event.setCancellationResult(result.asMinecraft());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerInteractEvent.LeftClickBlock event) {
        EventResult result = InteractionEvent.LEFT_CLICK_BLOCK.invoker().click(event.getPlayer(), event.getHand(), event.getPos(), event.getFace());
        if (result.isPresent()) {
            event.setCanceled(true);
            event.setCancellationResult(result.asMinecraft());
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(final BlockEvent.BreakEvent event) {
        EventResult result;
        if (event.getPlayer() instanceof ServerPlayer && event.getWorld() instanceof Level && (result = BlockEvent.BREAK.invoker().breakBlock((Level)event.getWorld(), event.getPos(), event.getState(), (ServerPlayer)event.getPlayer(), new IntValue(){

            @Override
            public int getAsInt() {
                return event.getExpToDrop();
            }

            @Override
            public void accept(int value) {
                event.setExpToDrop(value);
            }
        })).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(BlockEvent.EntityPlaceEvent event) {
        EventResult result;
        if (event.getWorld() instanceof Level && (result = BlockEvent.PLACE.invoker().placeBlock((Level)event.getWorld(), event.getPos(), event.getState(), event.getEntity())).isFalse()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(FMLServerAboutToStartEvent event) {
        LifecycleEvent.SERVER_BEFORE_START.invoker().stateChanged(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            PlayerEvent.CHANGE_DIMENSION.invoker().change((ServerPlayer)event.getPlayer(), (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Save event) {
        if (event.getWorld() instanceof ServerLevel) {
            ChunkEvent.SAVE_DATA.invoker().save(event.getChunk(), (ServerLevel)event.getWorld(), event.getData());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void event(ChunkDataEvent.Load event) {
        LevelAccessor level = event.getChunk().getWorldForge();
        if (!(level instanceof ServerLevel)) {
            level = ((WorldEventAttachment)event).architectury$getAttachedLevel();
        }
        ChunkEvent.LOAD_DATA.invoker().load(event.getChunk(), level instanceof ServerLevel ? (ServerLevel)level : null, event.getData());
    }

    public static interface WorldEventAttachment {
        public LevelAccessor architectury$getAttachedLevel();

        public void architectury$attachLevel(LevelAccessor var1);
    }

    public static class ModBasedEventHandler {
    }
}

