/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.block;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.types.Type;
import dev.architectury.hooks.block.forge.BlockEntityHooksImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityHooks {
    private BlockEntityHooks() {
    }

    public static <T extends BlockEntity> TypeBuilder<T> builder(Constructor<? extends T> constructor, Block ... blocks) {
        return new TypeBuilder<T>(constructor, (Set<Block>)ImmutableSet.copyOf((Object[])blocks));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void syncData(BlockEntity entity) {
        BlockEntityHooksImpl.syncData(entity);
    }

    public static class TypeBuilder<T extends BlockEntity> {
        private final Constructor<? extends T> constructor;
        private final Set<Block> validBlocks;

        private TypeBuilder(Constructor<? extends T> constructor, Set<Block> validBlocks) {
            this.constructor = constructor;
            this.validBlocks = validBlocks;
        }

        public BlockEntityType<T> build(@Nullable Type<?> type) {
            return new BlockEntityType(this.constructor::create, this.validBlocks, type);
        }
    }

    @FunctionalInterface
    public static interface Constructor<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }
}

