/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.biome.forge;

import com.google.common.collect.Lists;
import dev.architectury.hooks.level.biome.BiomeHooks;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.hooks.level.biome.ClimateProperties;
import dev.architectury.hooks.level.biome.EffectsProperties;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.hooks.level.biome.SpawnProperties;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="architectury")
public class BiomeModificationsImpl {
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> MODIFICATIONS = Lists.newArrayList();

    public static void addProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void postProcessProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void removeProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void replaceProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        MODIFICATIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    private static BiomeModifications.BiomeContext wrapSelectionContext(final BiomeLoadingEvent event) {
        return new BiomeModifications.BiomeContext(){
            BiomeProperties properties;
            {
                this.properties = new BiomeWrapped(event);
            }

            @Override
            @NotNull
            public ResourceLocation getKey() {
                return event.getName();
            }

            @Override
            @NotNull
            public BiomeProperties getProperties() {
                return this.properties;
            }
        };
    }

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        BiomeModifications.BiomeContext biomeContext = BiomeModificationsImpl.wrapSelectionContext(event);
        MutableBiomeWrapped mutableBiome = new MutableBiomeWrapped(event);
        for (Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>> pair : MODIFICATIONS) {
            if (!((Predicate)pair.getLeft()).test(biomeContext)) continue;
            ((BiConsumer)pair.getRight()).accept(biomeContext, mutableBiome);
        }
        MutableClimatePropertiesWrapped climateProperties = (MutableClimatePropertiesWrapped)mutableBiome.getClimateProperties();
        if (climateProperties.dirty) {
            event.setClimate(new Biome.ClimateSettings(climateProperties.precipitation, climateProperties.temperature, climateProperties.temperatureModifier, climateProperties.downfall));
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(BiomeLoadingEvent event) {
            super(event, new MutableClimatePropertiesWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new MutableGenerationSettingsBuilderWrapped(event.getGeneration()), new MutableSpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        @NotNull
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        @NotNull
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setCategory(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.BiomeCategory category) {
            this.event.setCategory(category);
            return this;
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setDepth(float depth) {
            this.event.setDepth(depth);
            return this;
        }

        @Override
        @NotNull
        public BiomeProperties.Mutable setScale(float scale) {
            this.event.setScale(scale);
            return this;
        }
    }

    public static class MutableClimatePropertiesWrapped
    implements ClimateProperties.Mutable {
        public Biome.Precipitation precipitation;
        public float temperature;
        public Biome.TemperatureModifier temperatureModifier;
        public float downfall;
        public boolean dirty;

        public MutableClimatePropertiesWrapped(Biome.ClimateSettings settings) {
            this(settings.f_47680_, settings.f_47681_, settings.f_47682_, settings.f_47683_);
        }

        public MutableClimatePropertiesWrapped(Biome.Precipitation precipitation, float temperature, Biome.TemperatureModifier temperatureModifier, float downfall) {
            this.precipitation = precipitation;
            this.temperature = temperature;
            this.temperatureModifier = temperatureModifier;
            this.downfall = downfall;
        }

        @Override
        @NotNull
        public Biome.Precipitation getPrecipitation() {
            return this.precipitation;
        }

        @Override
        public float getTemperature() {
            return this.temperature;
        }

        @Override
        @NotNull
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.temperatureModifier;
        }

        @Override
        public float getDownfall() {
            return this.downfall;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setPrecipitation(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.Precipitation precipitation) {
            this.precipitation = precipitation;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.temperature = temperature;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setTemperatureModifier(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            this.dirty = true;
            return this;
        }

        @Override
        @NotNull
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.downfall = downfall;
            this.dirty = true;
            return this;
        }
    }

    private static class MutableSpawnSettingsBuilderWrapped
    extends SpawnSettingsBuilderWrapped
    implements SpawnProperties.Mutable {
        public MutableSpawnSettingsBuilderWrapped(MobSpawnInfoBuilder builder) {
            super(builder);
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable setCreatureProbability(float probability) {
            this.builder.m_48368_(probability);
            return this;
        }

        @Override
        public SpawnProperties.Mutable addSpawn(MobCategory category, MobSpawnSettings.SpawnerData data) {
            this.builder.m_48376_(category, data);
            return this;
        }

        @Override
        public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
            boolean removed = false;
            for (MobCategory type : this.builder.getSpawnerTypes()) {
                if (!this.builder.getSpawner(type).removeIf(data -> predicate.test(type, (MobSpawnSettings.SpawnerData)data))) continue;
                removed = true;
            }
            return removed;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, MobSpawnSettings.MobSpawnCost cost) {
            this.builder.m_48370_(entityType, cost.m_48400_(), cost.m_48395_());
            return this;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            this.builder.m_48370_(entityType, mass, gravityLimit);
            return this;
        }

        @Override
        public SpawnProperties.Mutable clearSpawnCost(EntityType<?> entityType) {
            this.getMobSpawnCosts().remove(entityType);
            return this;
        }

        @Override
        @NotNull
        public SpawnProperties.Mutable setPlayerSpawnFriendly(boolean friendly) {
            this.builder.f_48365_ = friendly;
            return this;
        }
    }

    private static class MutableGenerationSettingsBuilderWrapped
    extends GenerationSettingsBuilderWrapped
    implements GenerationProperties.Mutable {
        public MutableGenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            super(generation);
        }

        @Override
        public GenerationProperties.Mutable setSurfaceBuilder(ConfiguredSurfaceBuilder<?> builder) {
            this.generation.m_47851_(builder);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addFeature(GenerationStep.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.generation.m_47842_(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(GenerationStep.Carving carving, ConfiguredWorldCarver<?> feature) {
            this.generation.m_47839_(carving, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addStructure(ConfiguredStructureFeature<?, ?> feature) {
            this.generation.m_47849_(feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeFeature(GenerationStep.Decoration decoration, ConfiguredFeature<?, ?> feature) {
            this.generation.getFeatures(decoration).removeIf(supplier -> supplier.get() == feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeCarver(GenerationStep.Carving carving, ConfiguredWorldCarver<?> feature) {
            this.generation.getCarvers(carving).removeIf(supplier -> supplier.get() == feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeStructure(ConfiguredStructureFeature<?, ?> feature) {
            this.generation.getStructures().removeIf(supplier -> supplier.get() == feature);
            return this;
        }
    }

    private static class SpawnSettingsBuilderWrapped
    implements SpawnProperties {
        protected final MobSpawnInfoBuilder builder;

        public SpawnSettingsBuilderWrapped(MobSpawnInfoBuilder builder) {
            this.builder = builder;
        }

        @Override
        public float getCreatureProbability() {
            return this.builder.getProbability();
        }

        @Override
        @NotNull
        public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getSpawners() {
            return this.builder.f_48362_;
        }

        @Override
        @NotNull
        public Map<EntityType<?>, MobSpawnSettings.MobSpawnCost> getMobSpawnCosts() {
            return this.builder.f_48363_;
        }

        @Override
        public boolean isPlayerSpawnFriendly() {
            return this.builder.f_48365_;
        }
    }

    private static class GenerationSettingsBuilderWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettingsBuilder generation;

        public GenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            this.generation = generation;
        }

        @Override
        @NotNull
        public Optional<Supplier<ConfiguredSurfaceBuilder<?>>> getSurfaceBuilder() {
            return this.generation.getSurfaceBuilder();
        }

        @Override
        @NotNull
        public List<Supplier<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving carving) {
            return this.generation.getCarvers(carving);
        }

        @Override
        @NotNull
        public List<List<Supplier<ConfiguredFeature<?, ?>>>> getFeatures() {
            return this.generation.f_47828_;
        }

        @Override
        @NotNull
        public List<Supplier<ConfiguredStructureFeature<?, ?>>> getStructureStarts() {
            return this.generation.getStructures();
        }
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final BiomeLoadingEvent event;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(BiomeLoadingEvent event) {
            this(event, new BiomeHooks.ClimateWrapped(event.getClimate()), new BiomeHooks.EffectsWrapped(event.getEffects()), new GenerationSettingsBuilderWrapped(event.getGeneration()), new SpawnSettingsBuilderWrapped(event.getSpawns()));
        }

        public BiomeWrapped(BiomeLoadingEvent event, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.event = event;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        @NotNull
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        @NotNull
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        @NotNull
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        @NotNull
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull Biome.BiomeCategory getCategory() {
            return this.event.getCategory();
        }

        @Override
        public float getDepth() {
            return this.event.getDepth();
        }

        @Override
        public float getScale() {
            return this.event.getScale();
        }
    }
}

