/*
 * Decompiled with CFR 0.152.
 */
package com.alrexu.throwability.common.network;

import com.alrexu.throwability.ThrowabilityMod;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ItemThrowMessage {
    public UUID senderID = null;
    public float throwStrength = 0.0f;
    public boolean isAll = false;

    public static ItemThrowMessage decode(FriendlyByteBuf packet) {
        ItemThrowMessage message = new ItemThrowMessage();
        message.throwStrength = packet.readFloat();
        message.senderID = new UUID(packet.readLong(), packet.readLong());
        message.isAll = packet.readBoolean();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void send(Player player, float throwStrength, boolean isAll) {
        ItemThrowMessage message = new ItemThrowMessage();
        message.throwStrength = throwStrength;
        message.senderID = player.m_142081_();
        message.isAll = isAll;
        ThrowabilityMod.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)message);
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeFloat(this.throwStrength);
        packet.writeLong(this.senderID.getLeastSignificantBits());
        packet.writeLong(this.senderID.getMostSignificantBits());
        packet.writeBoolean(this.isAll);
    }
}

