/*
 * Decompiled with CFR 0.152.
 */
package com.alrexu.throwability.common.network.handler;

import com.alrexu.throwability.common.capability.IThrow;
import com.alrexu.throwability.common.capability.capabilities.ThrowProvider;
import com.alrexu.throwability.common.network.ItemThrowMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class ItemThrowMessageHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(ItemThrowMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                LocalPlayer player1 = Minecraft.m_91087_().f_91074_;
                if (player1 == null) {
                    return;
                }
                Level world = player1.f_19853_;
                player = world.m_46003_(message.senderID);
            } else {
                player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            }
            if (player == null) {
                return;
            }
            IThrow iThrow = ThrowProvider.get((Entity)player);
            if (iThrow == null) {
                return;
            }
            iThrow.throwItem((Player)player, message.isAll, message.throwStrength);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void handleServer(ItemThrowMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            IThrow iThrow = ThrowProvider.get((Entity)player);
            if (iThrow == null) {
                return;
            }
            iThrow.throwItem((Player)player, message.isAll, message.throwStrength);
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

