/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ambientenvironment;

import com.blamejared.ambientenvironment.mixin.BiomeColorsAccessor;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1163;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_3543;
import net.minecraft.class_5819;
import net.minecraft.class_6539;
import net.minecraft.class_6677;

public class AmbientEnvironmentCommon {
    public static final int NOISE_OCTAVES = 2;
    public static final List<Integer> OCTAVES = IntStream.rangeClosed(0, 2).boxed().toList();
    public static final class_3543 GRASS_NOISE = new class_3543((class_5819)new class_6677((long)"NOISE_GRASS".hashCode()), OCTAVES);
    public static final class_3543 WATER_NOISE = new class_3543((class_5819)new class_6677((long)"NOISE_WATER".hashCode()), OCTAVES);
    public static final class_6539 GRASS_RESOLVER = (class_6539)class_156.method_656(() -> {
        class_6539 baseResolver = class_1163.field_5665;
        return (biome, x, z) -> AmbientEnvironmentCommon.modifyColour(GRASS_NOISE, baseResolver, biome, x, z, 8.0, 0.25);
    });
    public static final class_6539 WATER_RESOLVER = (class_6539)class_156.method_656(() -> {
        class_6539 baseResolver = class_1163.field_5666;
        return (biome, x, z) -> AmbientEnvironmentCommon.modifyColour(WATER_NOISE, baseResolver, biome, x, z, 16.0, 0.3f);
    });

    public static void init() {
        BiomeColorsAccessor.setGrassColorResolver(GRASS_RESOLVER);
        BiomeColorsAccessor.setWaterColorResolver(WATER_RESOLVER);
    }

    private static int modifyColour(class_3543 generator, class_6539 resolver, class_1959 biome, double x, double z, double scale, double darkness) {
        int base = resolver.getColor(biome, x, z);
        double value = generator.method_16451(x / scale, z / scale, false);
        value = AmbientEnvironmentCommon.curve(0.0, 1.0, AmbientEnvironmentCommon.remap(value, -3.0, 3.0, 0.0, 1.0)) * darkness;
        return AmbientEnvironmentCommon.blend(base, 0, (float)value);
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    private static float[] getARGB(int hex) {
        return new float[]{AmbientEnvironmentCommon.getAlpha(hex), AmbientEnvironmentCommon.getRed(hex), AmbientEnvironmentCommon.getGreen(hex), AmbientEnvironmentCommon.getBlue(hex)};
    }

    private static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static double curve(double start, double end, double amount) {
        amount = class_3532.method_15350((double)amount, (double)0.0, (double)1.0);
        amount = class_3532.method_15350((double)((amount - start) / (end - start)), (double)0.0, (double)1.0);
        return class_3532.method_15350((double)(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90.0 * amount))) * Math.cos(Math.sin(Math.tan(amount)))), (double)0.0, (double)1.0);
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = AmbientEnvironmentCommon.getARGB(color2);
        float[] rgb2 = AmbientEnvironmentCommon.getARGB(color1);
        return AmbientEnvironmentCommon.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
}

