/*
 * Decompiled with CFR 0.152.
 */
package com.flier268.autoharvest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.fabricmc.loader.api.FabricLoader;

public class Configure {
    private File configFile;
    public FlowerISseed flowerISseed = new FlowerISseed();
    public Effect_radius effect_radius = new Effect_radius();
    public TickSkip tickSkip = new TickSkip();
    public KeepFishingRodAlive keepFishingRodAlive = new KeepFishingRodAlive();

    public Configure() {
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve("AutoHarvest.json").toFile();
        this.flowerISseed.value = false;
    }

    public Configure load() {
        block17: {
            try {
                if (!Files.exists(this.configFile.toPath(), new LinkOption[0])) {
                    return this;
                }
                String jsonStr = new String(Files.readAllBytes(this.configFile.toPath()));
                if (jsonStr.equals("")) break block17;
                JsonObject jsonObject = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                if (jsonObject.has(this.flowerISseed.name)) {
                    try {
                        this.flowerISseed.value = jsonObject.getAsJsonPrimitive(this.flowerISseed.name).getAsBoolean();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(this.effect_radius.name)) {
                    try {
                        this.effect_radius.value = jsonObject.getAsJsonPrimitive(this.effect_radius.name).getAsInt();
                        if (this.effect_radius.value < 0 || this.effect_radius.value > 3) {
                            this.effect_radius.value = 3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(this.tickSkip.name)) {
                    try {
                        this.tickSkip.value = jsonObject.getAsJsonPrimitive(this.tickSkip.name).getAsInt();
                        if (this.tickSkip.value < 0 || this.tickSkip.value > 100) {
                            this.tickSkip.value = 0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (jsonObject.has(this.keepFishingRodAlive.name)) {
                    try {
                        this.keepFishingRodAlive.value = jsonObject.getAsJsonPrimitive(this.keepFishingRodAlive.name).getAsBoolean();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Configure save() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(this.flowerISseed.name, Boolean.valueOf(this.flowerISseed.value));
        jsonObject.addProperty(this.effect_radius.name, (Number)this.effect_radius.value);
        jsonObject.addProperty(this.tickSkip.name, (Number)this.tickSkip.value);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement el = JsonParser.parseString((String)jsonObject.toString());
        try (PrintWriter out = new PrintWriter(this.configFile);){
            out.println(gson.toJson(el));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this;
    }

    public static class FlowerISseed {
        public boolean value = false;
        private String name = "flowerISseed";
    }

    public static class Effect_radius {
        public int value = 3;
        private String name = "effect_radius";
        public static final int Max = 3;
        public static final int Min = 0;
    }

    public static class TickSkip {
        public int value = 0;
        private String name = "tick_skip";
        public static final int Max = 100;
        public static final int Min = 0;
    }

    public static class KeepFishingRodAlive {
        public boolean value = true;
        String name = "keepFishingRodAlive";
    }
}

