/*
 * Decompiled with CFR 0.152.
 */
package com.flier268.autoharvest;

import com.flier268.autoharvest.AutoHarvest;
import com.flier268.autoharvest.Configure;
import com.flier268.autoharvest.CropManager;
import java.util.Collection;
import java.util.Iterator;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_746;

public class TickListener {
    private final Configure configure;
    private class_746 p;
    private long fishBitesAt = 0L;
    private class_1799 lastUsedItem = null;

    public TickListener(Configure configure, class_746 player) {
        this.configure = configure;
        this.p = player;
        ClientTickEvents.END_CLIENT_TICK.register(e -> {
            if (AutoHarvest.instance.overlayRemainingTick > 0) {
                --AutoHarvest.instance.overlayRemainingTick;
            }
            if (AutoHarvest.instance.Switch) {
                this.onTick(e.field_1724);
            }
        });
    }

    public void Reset() {
        this.lastUsedItem = null;
        this.fishBitesAt = 0L;
    }

    public void onTick(class_746 player) {
        try {
            if (player != this.p) {
                this.p = player;
                AutoHarvest.instance.Switch = false;
                AutoHarvest.msg("notify.turn.off", new Object[0]);
                return;
            }
            if (AutoHarvest.instance.taskManager.Count() > 0) {
                AutoHarvest.instance.taskManager.RunATask();
                return;
            }
            switch (AutoHarvest.instance.mode) {
                case SEED: {
                    this.seedTick();
                    break;
                }
                case HARVEST: {
                    this.harvestTick();
                    break;
                }
                case PLANT: {
                    this.plantTick();
                    break;
                }
                case Farmer: {
                    this.harvestTick();
                    this.plantTick();
                    break;
                }
                case FEED: {
                    this.feedTick();
                    break;
                }
                case FISHING: {
                    this.fishingTick();
                    break;
                }
                case BONEMEALING: {
                    this.bonemealingTick();
                }
            }
            if (AutoHarvest.instance.mode != AutoHarvest.HarvestMode.FISHING) {
                AutoHarvest.instance.taskManager.Add_TickSkip(AutoHarvest.instance.configure.tickSkip.value);
            }
        }
        catch (Exception ex) {
            AutoHarvest.msg("notify.tick_error", new Object[0]);
            AutoHarvest.msg("notify.turn.off", new Object[0]);
            ex.printStackTrace();
            AutoHarvest.instance.Switch = false;
        }
    }

    private void seedTick() {
        class_1937 w = this.p.method_5770();
        int X = (int)Math.floor(this.p.method_23317());
        int Y = (int)Math.floor(this.p.method_23318());
        int Z = (int)Math.floor(this.p.method_23321());
        for (int deltaY = 3; deltaY >= -2; --deltaY) {
            for (int deltaX = -this.configure.effect_radius.value; deltaX <= this.configure.effect_radius.value; ++deltaX) {
                for (int deltaZ = -this.configure.effect_radius.value; deltaZ <= this.configure.effect_radius.value; ++deltaZ) {
                    class_2338 pos = new class_2338(X + deltaX, Y + deltaY, Z + deltaZ);
                    if (!CropManager.isWeedBlock(w, pos) && (!AutoHarvest.instance.configure.flowerISseed.value || !CropManager.isFlowerBlock(w, pos))) continue;
                    assert (class_310.method_1551().field_1761 != null);
                    class_310.method_1551().field_1761.method_2910(pos, class_2350.field_11036);
                    return;
                }
            }
        }
    }

    private void harvestTick() {
        class_1937 w = this.p.method_5770();
        int X = (int)Math.floor(this.p.method_23317());
        int Y = (int)Math.floor(this.p.method_23318() + 0.2);
        int Z = (int)Math.floor(this.p.method_23321());
        for (int deltaX = -this.configure.effect_radius.value; deltaX <= this.configure.effect_radius.value; ++deltaX) {
            for (int deltaZ = -this.configure.effect_radius.value; deltaZ <= this.configure.effect_radius.value; ++deltaZ) {
                for (int deltaY = -1; deltaY <= 1; ++deltaY) {
                    class_2248 block;
                    class_2338 pos = new class_2338(X + deltaX, Y + deltaY, Z + deltaZ);
                    class_2680 state = w.method_8320(pos);
                    if (!CropManager.isCropMature(w, pos, state, block = state.method_26204())) continue;
                    if (block == class_2246.field_16999) {
                        class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX) + 0.5, (double)(Y + deltaY) - 0.5, (double)(Z + deltaZ) + 0.5), class_2350.field_11036, pos, false);
                        assert (class_310.method_1551().field_1761 != null);
                        class_310.method_1551().field_1761.method_2896(this.p, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                    } else {
                        assert (class_310.method_1551().field_1761 != null);
                        class_310.method_1551().field_1761.method_2910(pos, class_2350.field_11036);
                    }
                    return;
                }
            }
        }
    }

    private void minusOneInHand() {
        class_1799 st = this.p.method_6047();
        if (st != null) {
            if (st.method_7947() <= 1) {
                this.p.method_6122(class_1268.field_5808, class_1799.field_8037);
            } else {
                st.method_7939(st.method_7947() - 1);
            }
        }
    }

    private class_1799 tryFillItemInHand() {
        class_1799 itemStack = this.p.method_6047();
        if (itemStack.method_7960()) {
            if (this.lastUsedItem != null && !this.lastUsedItem.method_7960()) {
                class_2371 inv = this.p.method_31548().field_7547;
                for (int idx = 0; idx < 36; ++idx) {
                    class_1799 s = (class_1799)inv.get(idx);
                    if (s.method_7909() != this.lastUsedItem.method_7909() || s.method_7919() != this.lastUsedItem.method_7919() || s.method_7985()) continue;
                    AutoHarvest.instance.taskManager.Add_MoveItem(idx, this.p.method_31548().field_7545);
                    return s;
                }
            }
            return null;
        }
        return itemStack;
    }

    private int tryReplacingFishingRod() {
        class_1799 itemStack = this.p.method_6047();
        if (CropManager.isRod(itemStack) && (!this.configure.keepFishingRodAlive.value || itemStack.method_7936() - itemStack.method_7919() > 1)) {
            return 0;
        }
        class_2371 inv = this.p.method_31548().field_7547;
        for (int idx = 0; idx < 36; ++idx) {
            class_1799 s = (class_1799)inv.get(idx);
            if (!CropManager.isRod(s) || this.configure.keepFishingRodAlive.value && s.method_7936() - s.method_7919() <= 1) continue;
            AutoHarvest.instance.taskManager.Add_MoveItem(idx, this.p.method_31548().field_7545);
            return 1;
        }
        return -1;
    }

    private void plantTick() {
        class_1799 handItem = this.tryFillItemInHand();
        if (handItem == null) {
            return;
        }
        if (!CropManager.isSeed(handItem)) {
            if (CropManager.isCocoa(handItem)) {
                this.plantCocoaTick(handItem);
            }
            return;
        }
        class_1937 w = this.p.method_5770();
        int X = (int)Math.floor(this.p.method_23317());
        int Y = (int)Math.floor(this.p.method_23318() + 0.2);
        int Z = (int)Math.floor(this.p.method_23321());
        for (int deltaX = -this.configure.effect_radius.value; deltaX <= this.configure.effect_radius.value; ++deltaX) {
            for (int deltaZ = -this.configure.effect_radius.value; deltaZ <= this.configure.effect_radius.value; ++deltaZ) {
                class_2338 pos = new class_2338(X + deltaX, Y, Z + deltaZ);
                if (w.method_8320(pos).method_26204() != class_2246.field_10124) continue;
                class_2338 downPos = pos.method_10074();
                class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX) + 0.5, (double)Y, (double)(Z + deltaZ) + 0.5), class_2350.field_11036, downPos, false);
                w.method_8320(pos.method_10093(class_2350.field_11033)).method_26184((class_4538)w, pos);
                if (!CropManager.canPlantOn(handItem.method_7909(), w, pos)) continue;
                this.lastUsedItem = handItem.method_7972();
                assert (class_310.method_1551().field_1761 != null);
                class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                this.minusOneInHand();
                return;
            }
        }
    }

    private void plantCocoaTick(class_1799 handItem) {
        class_1937 w = this.p.method_5770();
        int X = (int)Math.floor(this.p.method_23317());
        int Y = (int)Math.floor(this.p.method_23318() + 0.2);
        int Z = (int)Math.floor(this.p.method_23321());
        for (int deltaX = -this.configure.effect_radius.value; deltaX <= this.configure.effect_radius.value; ++deltaX) {
            for (int deltaZ = -this.configure.effect_radius.value; deltaZ <= this.configure.effect_radius.value; ++deltaZ) {
                for (int deltaY = 0; deltaY <= 7; ++deltaY) {
                    class_2680 jungleBlock;
                    class_2338 pos = new class_2338(X + deltaX, Y + deltaY, Z + deltaZ);
                    if (!this.canReachBlock(this.p, pos) || !CropManager.isJungleLog(jungleBlock = w.method_8320(pos))) continue;
                    class_2350 tmpFace = class_2350.field_11034;
                    class_2338 tmpPos = pos.method_10081(tmpFace.method_10163());
                    if (w.method_8320(tmpPos).method_26204() == class_2246.field_10124) {
                        this.lastUsedItem = handItem.method_7972();
                        class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX + 1), (double)(Y + deltaY) + 0.5, (double)(Z + deltaZ) + 0.5), tmpFace, pos, false);
                        assert (class_310.method_1551().field_1761 != null);
                        class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                        this.minusOneInHand();
                        return;
                    }
                    tmpFace = class_2350.field_11039;
                    tmpPos = pos.method_10081(tmpFace.method_10163());
                    if (w.method_8320(tmpPos).method_26204() == class_2246.field_10124) {
                        this.lastUsedItem = handItem.method_7972();
                        class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX), (double)(Y + deltaY) + 0.5, (double)(Z + deltaZ) + 0.5), tmpFace, pos, false);
                        assert (class_310.method_1551().field_1761 != null);
                        class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                        this.minusOneInHand();
                        return;
                    }
                    tmpFace = class_2350.field_11035;
                    tmpPos = pos.method_10081(tmpFace.method_10163());
                    if (w.method_8320(tmpPos).method_26204() == class_2246.field_10124) {
                        this.lastUsedItem = handItem.method_7972();
                        class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX) + 0.5, (double)(Y + deltaY) + 0.5, (double)(Z + deltaZ + 1)), tmpFace, pos, false);
                        assert (class_310.method_1551().field_1761 != null);
                        class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                        this.minusOneInHand();
                        return;
                    }
                    tmpFace = class_2350.field_11043;
                    tmpPos = pos.method_10081(tmpFace.method_10163());
                    if (w.method_8320(tmpPos).method_26204() != class_2246.field_10124) continue;
                    this.lastUsedItem = handItem.method_7972();
                    class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX) + 0.5, (double)(Y + deltaY) + 0.5, (double)(Z + deltaZ)), tmpFace, pos, false);
                    assert (class_310.method_1551().field_1761 != null);
                    class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                    this.minusOneInHand();
                    return;
                }
            }
        }
    }

    private boolean canReachBlock(class_746 playerEntity, class_2338 blockpos) {
        double d2;
        double d1;
        double d0 = playerEntity.method_23317() - ((double)blockpos.method_10263() + 0.5);
        double d3 = d0 * d0 + (d1 = playerEntity.method_23318() - ((double)blockpos.method_10264() + 0.5) + 1.5) * d1 + (d2 = playerEntity.method_23321() - ((double)blockpos.method_10260() + 0.5)) * d2;
        return d3 <= 36.0;
    }

    private void feedTick() {
        class_1799 handItem = this.tryFillItemInHand();
        if (handItem == null) {
            return;
        }
        class_238 box = new class_238(this.p.method_23317() - (double)this.configure.effect_radius.value, this.p.method_23318() - (double)this.configure.effect_radius.value, this.p.method_23321() - (double)this.configure.effect_radius.value, this.p.method_23317() + (double)this.configure.effect_radius.value, this.p.method_23318() + (double)this.configure.effect_radius.value, this.p.method_23321() + (double)this.configure.effect_radius.value);
        Collection needShearAnimalList = CropManager.SHEAR_MAP.get((Object)handItem.method_7909());
        for (Class type : needShearAnimalList) {
            Iterator iterator = this.p.method_5770().method_8390(type, box, animalEntity -> {
                if (animalEntity instanceof class_1472) {
                    return !animalEntity.method_6109() && !((class_1472)animalEntity).method_6629();
                }
                return false;
            }).iterator();
            if (!iterator.hasNext()) continue;
            class_1429 e = (class_1429)iterator.next();
            this.lastUsedItem = handItem.method_7972();
            assert (class_310.method_1551().field_1761 != null);
            class_310.method_1551().field_1761.method_2905((class_1657)this.p, (class_1297)e, class_1268.field_5808);
            return;
        }
        Collection needFeedAnimalList = CropManager.FEED_MAP.get((Object)handItem.method_7909());
        for (Class type : needFeedAnimalList) {
            for (class_1429 e : this.p.method_5770().method_8390(type, box, animalEntity -> animalEntity.method_5618() >= 0 && !animalEntity.method_6479())) {
                this.lastUsedItem = handItem.method_7972();
                assert (class_310.method_1551().field_1761 != null);
                class_310.method_1551().field_1761.method_2905((class_1657)this.p, (class_1297)e, class_1268.field_5808);
            }
        }
    }

    private long getWorldTime() {
        assert (class_310.method_1551().field_1687 != null);
        return class_310.method_1551().field_1687.method_8510();
    }

    private boolean isFishBites(class_746 player) {
        class_1536 fishEntity = player.field_7513;
        return fishEntity != null && fishEntity.field_6014 - fishEntity.method_23317() == 0.0 && fishEntity.field_5969 - fishEntity.method_23321() == 0.0 && fishEntity.field_6036 - fishEntity.method_23318() < -0.05;
    }

    private void fishingTick() {
        switch (this.tryReplacingFishingRod()) {
            case -1: {
                AutoHarvest.msg("notify.turn.off", new Object[0]);
                AutoHarvest.instance.Switch = false;
                break;
            }
            case 0: {
                if (this.fishBitesAt == 0L && this.isFishBites(this.p)) {
                    this.fishBitesAt = this.getWorldTime();
                    assert (class_310.method_1551().field_1761 != null);
                    class_310.method_1551().field_1761.method_2919((class_1657)this.p, (class_1937)class_310.method_1551().field_1687, class_1268.field_5808);
                }
                if (this.fishBitesAt == 0L || this.fishBitesAt + 20L > this.getWorldTime()) break;
                assert (class_310.method_1551().field_1761 != null);
                class_310.method_1551().field_1761.method_2919((class_1657)this.p, (class_1937)class_310.method_1551().field_1687, class_1268.field_5808);
                this.fishBitesAt = 0L;
                break;
            }
        }
    }

    private void bonemealingTick() {
        class_1799 handItem = this.p.method_6047();
        if (handItem == null || !CropManager.isBoneMeal(handItem)) {
            return;
        }
        handItem = this.tryFillItemInHand();
        class_1937 w = this.p.method_5770();
        int X = (int)Math.floor(this.p.method_23317());
        int Y = (int)Math.floor(this.p.method_23318());
        int Z = (int)Math.floor(this.p.method_23321());
        for (int deltaY = 3; deltaY >= -2; --deltaY) {
            for (int deltaX = -this.configure.effect_radius.value; deltaX <= this.configure.effect_radius.value; ++deltaX) {
                for (int deltaZ = -this.configure.effect_radius.value; deltaZ <= this.configure.effect_radius.value; ++deltaZ) {
                    class_2338 pos = new class_2338(X + deltaX, Y + deltaY, Z + deltaZ);
                    class_2680 blockState = w.method_8320(pos);
                    class_2248 block = blockState.method_26204();
                    if (!(block instanceof class_2256) || !((class_2256)block).method_9651((class_1922)w, pos, blockState, w.field_9236)) continue;
                    class_3965 blockHitResult = new class_3965(new class_243((double)(X + deltaX) + 0.5, (double)Y, (double)(Z + deltaZ) + 0.5), class_2350.field_11036, pos, false);
                    assert (handItem != null);
                    this.lastUsedItem = handItem.method_7972();
                    assert (class_310.method_1551().field_1761 != null);
                    class_310.method_1551().field_1761.method_2896(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_1268.field_5808, blockHitResult);
                    this.minusOneInHand();
                    return;
                }
            }
        }
    }
}

