/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.annotation.ConfigBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConfig {
    private final String name;
    private final Map<List<String>, String[]> categoryComments = Maps.newHashMap();

    public AbstractConfig(String name) {
        this.name = name;
    }

    public final void setupConfig(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
        AbstractConfig.setupConfig(this, builder, saveCallback);
    }

    protected void addToBuilder(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
    }

    protected void afterConfigReload() {
    }

    protected final void addComment(String ... comment) {
        this.addComment(Lists.newArrayList(), comment);
    }

    protected final void addComment(List<String> path, String ... comment) {
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw new IllegalStateException("Cannot set comment on base config");
        }
        this.categoryComments.put(path, comment);
    }

    public static void setupConfig(AbstractConfig config, ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
        boolean withCategory;
        HashMap categoryComments = Maps.newHashMap(config.categoryComments);
        boolean bl = withCategory = !StringUtils.isEmpty((CharSequence)config.name);
        if (withCategory) {
            String[] comment = (String[])categoryComments.remove(Lists.newArrayList());
            if (comment != null && comment.length != 0) {
                builder.comment(comment);
            }
            builder.push(config.name);
        }
        ConfigBuilder.serialize(builder, saveCallback, (Map<List<String>, String[]>)categoryComments, config);
        config.addToBuilder(builder, saveCallback);
        if (withCategory) {
            builder.pop();
        }
    }
}

