/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.network;

import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.network.message.Message;
import fuzs.puzzleslib.proxy.IProxy;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private final SimpleChannel channel;
    private final AtomicInteger discriminator;

    private NetworkHandler(SimpleChannel channel) {
        this.channel = channel;
        this.discriminator = new AtomicInteger();
    }

    public <T extends Message> void register(Class<T> clazz, Supplier<T> supplier, MessageDirection direction) {
        BiConsumer<Message, FriendlyByteBuf> encode = Message::write;
        Function<FriendlyByteBuf, Message> decode = buf -> {
            Message message = (Message)supplier.get();
            message.read((FriendlyByteBuf)buf);
            return message;
        };
        BiConsumer<Message, Supplier> handle = (msg, ctxSup) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxSup.get();
            LogicalSide receptionSide = direction.getReceptionSide();
            if (ctx.getDirection().getReceptionSide() != receptionSide) {
                throw new IllegalStateException(String.format("Received message on wrong side, expected %s, was %s", receptionSide, ctx.getDirection().getReceptionSide()));
            }
            Object player = receptionSide.isClient() ? IProxy.INSTANCE.getClientPlayer() : ctx.getSender();
            ctx.enqueueWork(() -> NetworkHandler.lambda$register$1(msg, (Player)player, receptionSide));
            ctx.setPacketHandled(true);
        };
        this.channel.registerMessage(this.discriminator.getAndIncrement(), clazz, encode, decode, handle);
    }

    public void sendToServer(Message message) {
        Objects.requireNonNull(Minecraft.m_91087_().m_91403_(), "Cannot send packets when not in game!");
        Minecraft.m_91087_().m_91403_().m_104955_(this.toServerboundPacket(message));
    }

    public void sendTo(Message message, ServerPlayer player) {
        player.f_8906_.m_141995_(this.toClientboundPacket(message));
    }

    public void sendToAll(Message message) {
        IProxy.INSTANCE.getGameServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    public void sendToAllExcept(Message message, ServerPlayer exclude) {
        Packet<?> packet = this.toClientboundPacket(message);
        for (ServerPlayer player : IProxy.INSTANCE.getGameServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            player.f_8906_.m_141995_(packet);
        }
    }

    public void sendToAllNear(Message message, BlockPos pos, Level level) {
        this.sendToAllNearExcept(message, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level);
    }

    public void sendToAllNearExcept(Message message, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level) {
        IProxy.INSTANCE.getGameServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    public void sendToDimension(Message message, Level level) {
        this.sendToDimension(message, (ResourceKey<Level>)level.m_46472_());
    }

    public void sendToDimension(Message message, ResourceKey<Level> dimension) {
        IProxy.INSTANCE.getGameServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }

    private Packet<?> toServerboundPacket(Message message) {
        return this.channel.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_SERVER);
    }

    private Packet<?> toClientboundPacket(Message message) {
        return this.channel.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static NetworkHandler of(String modId) {
        return NetworkHandler.of(modId, false, false);
    }

    public static NetworkHandler of(String modId, boolean clientAcceptsVanillaOrMissing, boolean serverAcceptsVanillaOrMissing) {
        SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modId, "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions((Predicate)(clientAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).serverAcceptedVersions((Predicate)(serverAcceptsVanillaOrMissing ? NetworkRegistry.acceptMissingOr((String)PROTOCOL_VERSION) : PROTOCOL_VERSION::equals)).simpleChannel();
        return new NetworkHandler(channel);
    }

    private static /* synthetic */ void lambda$register$1(Message msg, Player player, LogicalSide receptionSide) {
        msg.handle(player, LogicalSidedProvider.WORKQUEUE.get(receptionSide));
    }
}

