/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.capability;

import com.mojang.datafixers.util.Either;
import fuzs.deathfinder.network.chat.TeleportToDeathProblem;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import java.time.Duration;
import java.time.Instant;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.level.Level;

public interface PlayerDeathTracker
extends CapabilityComponent {
    public BlockPos getLastDeathPosition();

    public ResourceKey<Level> getLastDeathDimension();

    public long getLastDeathDate();

    public void setLastDeathPosition(BlockPos var1);

    public void setLastDeathDimension(ResourceKey<Level> var1);

    public void setLastDeathDate(long var1);

    default public void captureDeathDate() {
        this.setLastDeathDate(System.currentTimeMillis());
    }

    default public Either<TeleportToDeathProblem, Unit> isValid(ResourceKey<Level> lastDeathDimension, BlockPos lastDeathPosition, int seconds) {
        if (this.isInvalid()) {
            return Either.left((Object)((Object)TeleportToDeathProblem.ALREADY_USED));
        }
        if (!this.getLastDeathPosition().equals((Object)lastDeathPosition) || !this.getLastDeathDimension().equals(lastDeathDimension)) {
            return Either.left((Object)((Object)TeleportToDeathProblem.NOT_MOST_RECENT));
        }
        if (seconds == -1 || Duration.between(Instant.ofEpochMilli(this.getLastDeathDate()), Instant.now()).toSeconds() < (long)seconds) {
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)((Object)TeleportToDeathProblem.TOO_LONG_AGO));
    }

    default public boolean isInvalid() {
        return this.getLastDeathPosition() == BlockPos.f_121853_;
    }

    default public void invalidate() {
        this.setLastDeathPosition(BlockPos.f_121853_);
    }
}

