/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.config;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.config.AbstractConfig;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.serialization.EntryCollectionBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ServerConfig
extends AbstractConfig {
    @Config
    public ComponentsConfig components = new ComponentsConfig();
    @Config
    public MessagesConfig messages = new MessagesConfig();

    public ServerConfig() {
        super("");
    }

    protected void afterConfigReload() {
        this.messages.afterConfigReload();
    }

    public static class ComponentsConfig
    extends AbstractConfig {
        @Config(description={"Add position component to death messages."})
        public boolean positionComponent = true;
        @Config(description={"Add dimension component to death messages."})
        public boolean dimensionComponent = true;
        @Config(description={"Add distance component to death messages."})
        public boolean distanceComponent = true;
        @Config(description={"Who should be allowed to click the position component to teleport there.", "Normal player can only teleport to their own death position once in a given time frame, if enabled.", "Operators can teleport to any death position without limitations, if enabled."})
        public TeleportRestriction allowTeleporting = TeleportRestriction.OPERATORS_ONLY;
        @Config(description={"Amount of seconds in which teleporting to the last death point is possible.", "Set to -1 to remove time limit."})
        @Config.IntRange(min=-1)
        public int teleportInterval = 300;

        public ComponentsConfig() {
            super("death_message_components");
        }
    }

    public static class MessagesConfig
    extends AbstractConfig {
        @Config(description={"Show death message for players."})
        public boolean playerDeaths = true;
        @Config(description={"Show death message for tamed entities."})
        public boolean petDeaths = true;
        @Config(description={"Show death message for villagers."})
        public boolean villagerDeaths = true;
        @Config(description={"Show death message for named entities."})
        public boolean namedEntityDeaths = true;
        @Config(description={"Show death message for all entities."})
        public boolean allDeaths = false;
        @Config(name="death_message_blacklist", description={"Entities to be excluded when \"all_deaths\" is enabled.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."})
        private List<String> deathMessageBlacklistRaw = EntryCollectionBuilder.getKeyList((IForgeRegistry)ForgeRegistries.ENTITIES, (IForgeRegistryEntry[])new EntityType[]{EntityType.f_20549_, EntityType.f_147034_});
        @Config(name="death_message_whitelist", description={"The only entities to be included when \"all_deaths\" is enabled. Takes precedence over blacklist.", "Format for every entry is \"<namespace>:<path>\". Path may use asterisk as wildcard parameter. Tags are not supported."})
        private List<String> deathMessageWhitelistRaw = Lists.newArrayList();
        public Set<EntityType<?>> deathMessageBlacklist;
        public Set<EntityType<?>> deathMessageWhitelist;

        public MessagesConfig() {
            super("death_messages");
        }

        protected void afterConfigReload() {
            this.deathMessageBlacklist = EntryCollectionBuilder.of((IForgeRegistry)ForgeRegistries.ENTITIES).buildSet(this.deathMessageBlacklistRaw);
            this.deathMessageWhitelist = EntryCollectionBuilder.of((IForgeRegistry)ForgeRegistries.ENTITIES).buildSet(this.deathMessageWhitelistRaw);
        }
    }

    public static enum TeleportRestriction {
        NO_ONE,
        OPERATORS_ONLY,
        EVERYONE;

    }
}

