/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.handler;

import fuzs.deathfinder.DeathFinder;
import fuzs.deathfinder.config.ServerConfig;
import fuzs.deathfinder.network.message.S2CAdvancedChatMessage;
import fuzs.deathfinder.util.DeathMessageBuilder;
import fuzs.deathfinder.util.DeathMessageSender;
import fuzs.puzzleslib.network.message.Message;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DeathMessageHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity entity = evt.getEntityLiving();
        if (entity.f_19853_.f_46443_ || !entity.f_19853_.m_46469_().m_46207_(GameRules.f_46142_)) {
            return;
        }
        block5: for (DeathMessageSource source : DeathMessageSource.values()) {
            if (!source.test(entity)) continue;
            DeathMessageBuilder builder = DeathMessageBuilder.from(entity).withPosition(((ServerConfig)DeathFinder.CONFIG.server()).components.positionComponent).withDimension(((ServerConfig)DeathFinder.CONFIG.server()).components.dimensionComponent).withDistance(((ServerConfig)DeathFinder.CONFIG.server()).components.distanceComponent);
            switch (source) {
                case PLAYER: {
                    this.handlePlayer((ServerPlayer)entity, builder, DeathMessageSender.from(entity.m_20194_()));
                    break;
                }
                case PET: {
                    LivingEntity livingEntity = ((TamableAnimal)entity).m_142480_();
                    if (!(livingEntity instanceof ServerPlayer)) break block5;
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    DeathFinder.NETWORK.sendTo((Message)new S2CAdvancedChatMessage(builder.build((Player)player), ChatType.SYSTEM, Util.f_137441_), player);
                    break;
                }
                case VILLAGER: {
                    DeathMessageSender.from(entity.m_20194_()).sendToAll(builder, false);
                    break;
                }
                default: {
                    DeathMessageSender.from(entity.m_20194_()).sendToAll(builder);
                    break;
                }
            }
            break;
        }
    }

    private void handlePlayer(ServerPlayer player, DeathMessageBuilder builder, DeathMessageSender sender) {
        Component component = player.m_21231_().m_19293_();
        player.f_8906_.m_9831_((Packet)new ClientboundPlayerCombatKillPacket(player.m_21231_(), component), p_9142_ -> {
            if (!p_9142_.isSuccess()) {
                String s = component.m_130668_(256);
                TranslatableComponent component1 = new TranslatableComponent("death.attack.message_too_long", new Object[]{new TextComponent(s).m_130940_(ChatFormatting.YELLOW)});
                MutableComponent component2 = new TranslatableComponent("death.attack.even_more_magic", new Object[]{player.m_5446_()}).m_130938_(arg_0 -> DeathMessageHandler.lambda$handlePlayer$0((Component)component1, arg_0));
                player.f_8906_.m_141995_((Packet)new ClientboundPlayerCombatKillPacket(player.m_21231_(), (Component)component2));
            }
        });
        Team team = player.m_5647_();
        if (team != null && team.m_7468_() != Team.Visibility.ALWAYS) {
            if (team.m_7468_() == Team.Visibility.HIDE_FOR_OTHER_TEAMS) {
                sender.sendMessageToAllTeamMembers((Player)player, builder);
            } else if (team.m_7468_() == Team.Visibility.HIDE_FOR_OWN_TEAM) {
                sender.sendMessageToTeamOrAllPlayers((Player)player, builder);
            }
        } else {
            sender.sendToAll(builder);
        }
    }

    private static boolean isAllowed(EntityType<?> type) {
        if (((ServerConfig)DeathFinder.CONFIG.server()).messages.deathMessageWhitelist.contains(type)) {
            return true;
        }
        return !((ServerConfig)DeathFinder.CONFIG.server()).messages.deathMessageBlacklist.contains(type);
    }

    private static /* synthetic */ Style lambda$handlePlayer$0(Component component1, Style p_143420_) {
        return p_143420_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component1));
    }

    private static enum DeathMessageSource {
        PLAYER(() -> ((ServerConfig)DeathFinder.CONFIG.server()).messages.allDeaths || ((ServerConfig)DeathFinder.CONFIG.server()).messages.playerDeaths, entity -> entity instanceof ServerPlayer && !entity.m_5833_()),
        ALL(() -> ((ServerConfig)DeathFinder.CONFIG.server()).messages.allDeaths, entity -> DeathMessageHandler.isAllowed(entity.m_6095_())),
        NAMED(() -> ((ServerConfig)DeathFinder.CONFIG.server()).messages.namedEntityDeaths, Entity::m_8077_),
        VILLAGER(() -> ((ServerConfig)DeathFinder.CONFIG.server()).messages.villagerDeaths, entity -> entity instanceof Villager),
        PET(() -> ((ServerConfig)DeathFinder.CONFIG.server()).messages.petDeaths, entity -> {
            TamableAnimal animal;
            return entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_142480_() instanceof ServerPlayer;
        });

        private final BooleanSupplier config;
        private final Predicate<LivingEntity> predicate;

        private DeathMessageSource(BooleanSupplier config, Predicate<LivingEntity> predicate) {
            this.config = config;
            this.predicate = predicate;
        }

        public boolean test(LivingEntity entity) {
            return this.config.getAsBoolean() && this.predicate.test(entity);
        }
    }
}

