/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.network.chat;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import fuzs.deathfinder.network.chat.AdvancedStyleSerializer;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public abstract class AdvancedClickEvent
extends ClickEvent {
    private static final BiMap<ResourceLocation, Class<? extends AdvancedClickEvent>> ADVANCED_EVENTS_REGISTRY = HashBiMap.create();
    private static final Map<ResourceLocation, BiFunction<ClickEvent.Action, String, ? extends AdvancedClickEvent>> ADVANCED_EVENTS_FACTORY = Maps.newHashMap();
    public static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Component.Serializer());
        gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new AdvancedStyleSerializer());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        return gsonBuilder.create();
    });

    public AdvancedClickEvent(ClickEvent.Action action, String string) {
        super(action, string);
    }

    public void serialize(JsonObject jsonObject) {
        jsonObject.addProperty("id", ((ResourceLocation)ADVANCED_EVENTS_REGISTRY.inverse().get(((Object)((Object)this)).getClass())).toString());
        jsonObject.addProperty("action", this.m_130622_().m_130649_());
        jsonObject.addProperty("value", this.m_130623_());
    }

    public abstract void deserialize(JsonObject var1);

    public static AdvancedClickEvent deserialize(ResourceLocation identifier, ClickEvent.Action action, String string, JsonObject jsonObject) {
        BiFunction<ClickEvent.Action, String, ? extends AdvancedClickEvent> factory = ADVANCED_EVENTS_FACTORY.get(identifier);
        if (factory == null) {
            throw new RuntimeException("Unknown advanced click event identifier");
        }
        AdvancedClickEvent clickEvent = factory.apply(action, string);
        clickEvent.deserialize(jsonObject);
        return clickEvent;
    }

    public static synchronized void register(ResourceLocation location, Class<? extends AdvancedClickEvent> clazz, BiFunction<ClickEvent.Action, String, ? extends AdvancedClickEvent> factory) {
        ADVANCED_EVENTS_REGISTRY.put((Object)location, clazz);
        ADVANCED_EVENTS_FACTORY.put(location, factory);
    }
}

