/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.network.client.message;

import com.google.gson.Gson;
import com.mojang.datafixers.util.Either;
import fuzs.deathfinder.DeathFinder;
import fuzs.deathfinder.capability.PlayerDeathTracker;
import fuzs.deathfinder.config.ServerConfig;
import fuzs.deathfinder.network.chat.AdvancedClickEvent;
import fuzs.deathfinder.network.chat.TeleportClickEvent;
import fuzs.deathfinder.network.chat.TeleportToDeathProblem;
import fuzs.deathfinder.registry.ModRegistry;
import fuzs.puzzleslib.network.message.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;

public class C2SDeathPointTeleportMessage
implements Message {
    private TeleportClickEvent clickEvent;

    public C2SDeathPointTeleportMessage() {
    }

    public C2SDeathPointTeleportMessage(TeleportClickEvent clickEvent) {
        this.clickEvent = clickEvent;
    }

    public void write(FriendlyByteBuf buf) {
        MutableComponent component = new TextComponent("").m_130948_(Style.f_131099_.m_131142_((ClickEvent)this.clickEvent));
        buf.m_130072_(AdvancedClickEvent.GSON.toJson((Object)component), 262144);
    }

    public void read(FriendlyByteBuf buf) {
        this.clickEvent = (TeleportClickEvent)((MutableComponent)GsonHelper.m_13798_((Gson)AdvancedClickEvent.GSON, (String)buf.m_130136_(262144), MutableComponent.class, (boolean)false)).m_7383_().m_131182_();
    }

    public DeathPointTeleportHandler makeHandler() {
        return new DeathPointTeleportHandler();
    }

    private static class DeathPointTeleportHandler
    extends Message.PacketHandler<C2SDeathPointTeleportMessage> {
        private DeathPointTeleportHandler() {
        }

        public void handle(C2SDeathPointTeleportMessage packet, Player player, Object gameInstance) {
            this.tryTeleportToDeath(player, packet.clickEvent).ifRight(unit -> ((ServerPlayer)player).f_8924_.m_129892_().m_82117_(player.m_20203_().m_81358_(2), packet.clickEvent.m_130623_())).ifLeft(problem -> player.m_5661_(problem.getComponent(), false));
        }

        private Either<TeleportToDeathProblem, Unit> tryTeleportToDeath(Player player, TeleportClickEvent event) {
            ServerConfig.TeleportRestriction teleportRestriction = ((ServerConfig)DeathFinder.CONFIG.server()).components.allowTeleporting;
            if (teleportRestriction != ServerConfig.TeleportRestriction.NO_ONE) {
                if (player.m_20310_(2)) {
                    return Either.right((Object)Unit.INSTANCE);
                }
                if (teleportRestriction == ServerConfig.TeleportRestriction.EVERYONE) {
                    return player.getCapability(ModRegistry.PLAYER_DEATH_TRACKER_CAPABILITY).map(tracker -> {
                        Either<TeleportToDeathProblem, Unit> either = event.acceptsTracker(player, (PlayerDeathTracker)tracker);
                        either.ifRight(unit -> tracker.invalidate());
                        return either;
                    }).orElse(Either.left((Object)((Object)TeleportToDeathProblem.OTHER_PROBLEM)));
                }
                return Either.left((Object)((Object)TeleportToDeathProblem.MISSING_PERMISSIONS));
            }
            return Either.left((Object)((Object)TeleportToDeathProblem.OTHER_PROBLEM));
        }
    }
}

