/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.util;

import fuzs.deathfinder.network.chat.TeleportClickEvent;
import fuzs.deathfinder.registry.ModRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DeathMessageBuilder {
    private final LivingEntity deadEntity;
    private boolean withPosition;
    private boolean withDimension;
    private boolean withDistance;

    private DeathMessageBuilder(LivingEntity deadEntity) {
        this.deadEntity = deadEntity;
    }

    public Component build(@Nullable Player receiver) {
        MutableComponent component = new TextComponent("").m_7220_(this.getVanillaComponent());
        if (this.withPosition) {
            component.m_130946_(" ").m_7220_(this.getPositionComponent(receiver));
        }
        if (this.withDimension) {
            component.m_130946_(" ").m_7220_(this.getDimensionComponent());
        }
        if (this.withDistance && receiver != null) {
            component.m_130946_(" ").m_7220_(this.getDistanceComponent(receiver));
        }
        return component;
    }

    public DeathMessageBuilder withPosition(boolean withPosition) {
        this.withPosition = withPosition;
        return this;
    }

    public DeathMessageBuilder withDimension(boolean withDimension) {
        this.withDimension = withDimension;
        return this;
    }

    public DeathMessageBuilder withDistance(boolean withDistance) {
        this.withDistance = withDistance;
        return this;
    }

    private Component getVanillaComponent() {
        return this.deadEntity.m_21231_().m_19293_();
    }

    private Component getPositionComponent(@Nullable Player receiver) {
        int x = this.deadEntity.m_146903_();
        int y = this.deadEntity.m_146904_();
        int z = this.deadEntity.m_146907_();
        MutableComponent component = ComponentUtils.m_130748_((Component)new TranslatableComponent("chat.coordinates", new Object[]{x, y, z})).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_((ClickEvent)new TeleportClickEvent(this.deadEntity.m_142081_(), (ResourceKey<Level>)this.deadEntity.f_19853_.m_46472_(), x, y, z)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
        if (receiver == this.deadEntity) {
            receiver.getCapability(ModRegistry.PLAYER_DEATH_TRACKER_CAPABILITY).ifPresent(tracker -> {
                tracker.setLastDeathDimension((ResourceKey<Level>)this.deadEntity.f_19853_.m_46472_());
                tracker.setLastDeathPosition(this.deadEntity.m_142538_());
                tracker.captureDeathDate();
            });
        }
        return new TranslatableComponent("death.message.position", new Object[]{component});
    }

    private Component getDimensionComponent() {
        String dimension = this.deadEntity.f_19853_.m_46472_().m_135782_().toString();
        return new TranslatableComponent("death.message.dimension", new Object[]{dimension});
    }

    private Component getDistanceComponent(@Nonnull Player receiver) {
        double distance;
        TranslatableComponent component = this.deadEntity.f_19853_.m_46472_() != receiver.f_19853_.m_46472_() ? new TranslatableComponent("death.message.distance.dimension") : ((distance = this.deadEntity.m_20182_().m_82554_(receiver.m_20182_())) < 3.0 ? new TranslatableComponent("death.message.distance.close") : new TranslatableComponent("death.message.distance.blocks", new Object[]{(int)distance}));
        return new TextComponent("(").m_7220_((Component)component).m_130946_(")");
    }

    public static DeathMessageBuilder from(LivingEntity entity) {
        return new DeathMessageBuilder(entity);
    }
}

