/*
 * Decompiled with CFR 0.152.
 */
package fuzs.deathfinder.util;

import fuzs.deathfinder.DeathFinder;
import fuzs.deathfinder.network.message.S2CAdvancedChatMessage;
import fuzs.deathfinder.util.DeathMessageBuilder;
import fuzs.puzzleslib.network.message.Message;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;

public class DeathMessageSender {
    private final MinecraftServer server;
    private final PlayerList playerList;

    private DeathMessageSender(MinecraftServer server) {
        this.server = server;
        this.playerList = server.m_6846_();
    }

    public void sendToAll(DeathMessageBuilder builder) {
        this.sendToAll(builder, true);
    }

    public void sendToAll(DeathMessageBuilder builder, boolean sendToConsole) {
        if (sendToConsole) {
            this.sendToConsole(builder);
        }
        this.sendToAll(builder, this.playerList.m_11314_().stream());
    }

    public void sendMessageToAllTeamMembers(Player player, DeathMessageBuilder builder) {
        Team team = player.m_5647_();
        if (team != null) {
            Stream<ServerPlayer> teamMembers = team.m_6809_().stream().map(arg_0 -> ((PlayerList)this.playerList).m_11255_(arg_0)).filter(players -> players != null && players != player);
            this.sendToAll(builder, teamMembers);
        }
    }

    public void sendMessageToTeamOrAllPlayers(Player player, DeathMessageBuilder message) {
        Team team = player.m_5647_();
        if (team == null) {
            this.sendToAll(message);
        } else {
            Stream<ServerPlayer> notTeamMembers = this.playerList.m_11314_().stream().filter(players -> player.m_5647_() != team);
            this.sendToAll(message, notTeamMembers);
        }
    }

    private void sendToConsole(DeathMessageBuilder builder) {
        this.server.m_6352_(builder.build(null), Util.f_137441_);
    }

    private void sendToAll(DeathMessageBuilder builder, Stream<ServerPlayer> players) {
        players.forEach(player -> DeathFinder.NETWORK.sendTo((Message)new S2CAdvancedChatMessage(builder.build((Player)player), ChatType.SYSTEM, Util.f_137441_), player));
    }

    public static DeathMessageSender from(MinecraftServer server) {
        return new DeathMessageSender(server);
    }
}

