/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.happytrails;

import com.mactso.happytrails.config.MyConfig;
import com.mactso.happytrails.config.TrailBlockManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HappyTrailsCommands {
    String subcommand = "";
    String value = "";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"happytrails").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"debugLevel").then(Commands.m_82129_((String)"debugLevel", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(ctx -> HappyTrailsCommands.setDebugLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"debugLevel")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"particlesOn").then(Commands.m_82127_((String)"true").executes(ctx -> HappyTrailsCommands.setParticlesOn(true)))).then(Commands.m_82127_((String)"false").executes(ctx -> HappyTrailsCommands.setParticlesOn(false))))).then(Commands.m_82127_((String)"setHappyTrailSpeed").then(Commands.m_82129_((String)"setHappyTrailSpeed", (ArgumentType)IntegerArgumentType.integer((int)-99, (int)99)).executes(ctx -> HappyTrailsCommands.setSpeedForBlock(((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"setHappyTrailSpeed")))))).then(Commands.m_82127_((String)"report").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            String report = "Configured Blocks : " + TrailBlockManager.getTrailHashAsString();
            MyConfig.sendChat((Player)p, report, TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
            return 1;
        }))).then(Commands.m_82127_((String)"info").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).m_81375_();
            BlockPos playerBlockPos = p.m_142538_();
            Level worldName = p.f_19853_;
            String dimensionName = p.f_19853_.m_6042_().toString();
            String chatMessage = "Dimension: " + dimensionName + "\n Current Values";
            MyConfig.sendBoldChat((Player)p, chatMessage, TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_GREEN));
            BlockState bs = p.f_19853_.m_8055_(playerBlockPos);
            Block b = p.f_19853_.m_8055_(playerBlockPos).m_60734_();
            if (bs.m_60795_()) {
                b = p.f_19853_.m_8055_(playerBlockPos.m_7495_()).m_60734_();
            }
            TrailBlockManager.TrailBlockItem t = TrailBlockManager.getTrailBlockInfo(b.getRegistryName().toString());
            int speed = 0;
            if (t != null) {
                speed = t.getTrailBlockSpeed();
            }
            chatMessage = "\n  Speed Level...........: " + speed + "\n  Standing On...........: " + b.getRegistryName().toString() + "\n  Player Position.......: " + playerBlockPos.toString() + "\n  Debug Level...........: " + MyConfig.aDebugLevel;
            MyConfig.sendChat((Player)p, chatMessage, TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
            return 1;
        })));
    }

    public static int setDebugLevel(int newDebugLevel) {
        MyConfig.aDebugLevel = newDebugLevel;
        MyConfig.pushDebugValue();
        return 1;
    }

    public static int setParticlesOn(boolean newParticlesOn) {
        MyConfig.aParticlesOn = newParticlesOn;
        MyConfig.pushNewParticlesOn();
        return 1;
    }

    public static int setSpeedForBlock(ServerPlayer p, int newSpeedValue) {
        BlockPos playerBlockPos = p.m_142538_();
        BlockState bs = p.f_19853_.m_8055_(playerBlockPos);
        Block block = p.f_19853_.m_8055_(playerBlockPos).m_60734_();
        if (bs.m_60795_()) {
            block = p.f_19853_.m_8055_(playerBlockPos.m_7495_()).m_60734_();
        }
        String key = block.getRegistryName().toString();
        if (newSpeedValue == 0) {
            TrailBlockManager.trailBlockHashtable.remove(key);
        } else {
            TrailBlockManager.trailBlockHashtable.put(key, new TrailBlockManager.TrailBlockItem(newSpeedValue));
        }
        MyConfig.pushValues();
        return 1;
    }
}

