/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.happytrails.config;

import com.mactso.happytrails.config.TrailBlockManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="happytrails", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int aDebugLevel;
    public static boolean aParticlesOn;
    public static String[] defaultTrailBlocks;
    public static String defaultTrailBlocks6464;
    public static final Boolean BOLD;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
            TrailBlockManager.trailBlockInit();
        }
    }

    public static void pushDebugValue() {
        if (aDebugLevel > 0) {
            System.out.println("Happy Trails Debug Level:" + aDebugLevel);
        }
        MyConfig.COMMON.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushNewParticlesOn() {
        MyConfig.COMMON.particlesOn.set((Object)aParticlesOn);
    }

    public static void pushValues() {
        MyConfig.COMMON.defaultTrailBlocksActual.set((Object)TrailBlockManager.getTrailHashAsString());
    }

    public static void sendChat(Player p, String chatMessage, TextColor textColor) {
        TextComponent component = new TextComponent(chatMessage);
        component.m_7383_().m_131148_(textColor);
        p.m_6352_((Component)component, p.m_142081_());
    }

    public static void sendBoldChat(Player p, String chatMessage, TextColor textColor) {
        TextComponent component = new TextComponent(chatMessage);
        component.m_7383_().m_131136_(Boolean.valueOf(true));
        component.m_7383_().m_131148_(textColor);
        p.m_6352_((Component)component, p.m_142081_());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        defaultTrailBlocks6464 = (String)MyConfig.COMMON.defaultTrailBlocksActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Happy Trails Debug: " + aDebugLevel);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        BOLD = true;
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue particlesOn;
        public final ForgeConfigSpec.ConfigValue<String> defaultTrailBlocksActual;
        public final String defaultTrailBlocks6464 = "minecraft:cut_copper_slab,22;minecraft:tall_grass,-30;minecraft:exposed_cut_copper_slab,33;minecraft:fern,-22;minecraft:grass,-22;minecraft:diamond_block,99;minecraft:water,11;minecraft:dirt_path,11;minecraft:stone_brick_slab,33;minecraft:weathered_cut_copper_slab,44;minecraft:stone_bricks,33;minecraft:large_fern,-30;minecraft:sand,-22;";

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Happy Trail Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("happytrails.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.particlesOn = builder.comment("Particles On: [true] / false").translation("happytrails.config.particlesOn").define("particlesOn", () -> true);
            builder.pop();
            builder.push("Trail Values 6464");
            this.defaultTrailBlocksActual = builder.comment("Trail Block String 6464").translation("happytrails.configdefaultTrailBlocksActual").define("defaultTrailBlocksActual", (Object)"minecraft:cut_copper_slab,22;minecraft:tall_grass,-30;minecraft:exposed_cut_copper_slab,33;minecraft:fern,-22;minecraft:grass,-22;minecraft:diamond_block,99;minecraft:water,11;minecraft:dirt_path,11;minecraft:stone_brick_slab,33;minecraft:weathered_cut_copper_slab,44;minecraft:stone_bricks,33;minecraft:large_fern,-30;minecraft:sand,-22;");
            builder.pop();
        }
    }
}

