/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.config;

import com.google.common.collect.Sets;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.injectables.HierarchicalConfigManagerFactory;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.NamespacedHierarchicalConfigManager;
import dev.the_fireplace.mobrebirth.config.DefaultMobSettings;
import dev.the_fireplace.mobrebirth.config.MobSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

@Singleton
public final class MobSettingsManager {
    private final NamespacedHierarchicalConfigManager<MobSettings> hierarchicalConfigManager;
    private final ConfigStateManager configStateManager;
    private final DefaultMobSettings defaultSettings;
    private final Set<class_2960> allowedEntityIdentifiers;

    @Inject
    public MobSettingsManager(HierarchicalConfigManagerFactory hierarchicalConfigManagerFactory, ConfigStateManager configStateManager, DefaultMobSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
        this.configStateManager = configStateManager;
        this.allowedEntityIdentifiers = class_2378.field_11145.method_10235().stream().filter(id -> ((class_1299)class_2378.field_11145.method_10223(id)).method_5896()).collect(Collectors.toSet());
        this.hierarchicalConfigManager = hierarchicalConfigManagerFactory.createNamespaced("mobrebirth_customMobSettings", (HierarchicalConfig)defaultSettings, this.allowedEntityIdentifiers);
    }

    public Collection<class_2960> getAllowedMobIds() {
        return this.allowedEntityIdentifiers;
    }

    public Collection<class_2960> getMobIdsWithCustomSettings() {
        return this.hierarchicalConfigManager.getCustoms();
    }

    public Collection<class_2960> getMobIdsWithoutCustomSettings() {
        HashSet idsWithoutSettings = Sets.newHashSet(this.allowedEntityIdentifiers);
        idsWithoutSettings.removeAll(this.getMobIdsWithCustomSettings());
        return idsWithoutSettings;
    }

    public MobSettings getSettings(class_2960 mobId) {
        return (MobSettings)this.hierarchicalConfigManager.get(mobId);
    }

    public boolean isCustom(class_2960 mobId) {
        return this.hierarchicalConfigManager.isCustom(mobId);
    }

    public void addCustom(class_2960 mobId, MobSettings settings) {
        this.hierarchicalConfigManager.addCustom(mobId, (HierarchicalConfig)settings);
    }

    public boolean deleteCustom(class_2960 mobId) {
        return this.hierarchicalConfigManager.deleteCustom(mobId);
    }

    public void saveAll() {
        this.configStateManager.save((Config)this.defaultSettings);
        this.hierarchicalConfigManager.saveAllCustoms();
    }
}

