/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.mobrebirth.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.mobrebirth.MobRebirthConstants;
import dev.the_fireplace.mobrebirth.config.MobSettings;
import dev.the_fireplace.mobrebirth.config.MobSettingsManager;
import dev.the_fireplace.mobrebirth.domain.config.ConfigValues;
import dev.the_fireplace.mobrebirth.domain.event.DeathHandler;
import dev.the_fireplace.mobrebirth.entrypoints.MainEntrypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1463;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1550;
import net.minecraft.class_1569;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

@Implementation
public final class Death
implements DeathHandler {
    private static final int KILLER_RABBIT_TYPE = 99;
    private final ConfigValues configValues;
    private final MobSettingsManager mobSettingsManager;
    private class_1309 livingEntity;
    private MobSettings mobSettings;

    @Inject
    public Death(ConfigValues configValues, MobSettingsManager mobSettingsManager) {
        this.configValues = configValues;
        this.mobSettingsManager = mobSettingsManager;
    }

    @Override
    public void onDeath(class_1309 livingEntity, class_1282 damageSource) {
        if (!livingEntity.method_5770().method_8608()) {
            this.livingEntity = livingEntity;
            this.mobSettings = this.mobSettingsManager.getSettings(this.getId((class_1297)livingEntity));
            boolean enabled = this.mobSettings.isEnabled();
            if (!enabled) {
                return;
            }
            if (this.rebirthIsAllowedFromSource(damageSource) && this.rebirthIsAllowedInBiome()) {
                this.triggerRebirth(this.getMobCountToSpawn());
            }
        }
    }

    private boolean rebirthIsAllowedFromSource(class_1282 damageSource) {
        if (damageSource.method_5529() instanceof class_1657) {
            return this.mobSettings.isRebirthFromPlayer();
        }
        return this.mobSettings.isRebirthFromNonPlayer();
    }

    private boolean rebirthIsAllowedForEntityCategory() {
        return this.livingEntity instanceof class_1569 || this.configValues.getAllowAnimalRebirth() && this.livingEntity instanceof class_1429;
    }

    private boolean rebirthIsAllowedForEntityType() {
        if (this.configValues.getVanillaRebirthOnly() && !this.isVanilla(this.livingEntity)) {
            return false;
        }
        if (this.isBoss()) {
            return this.configValues.getAllowBossRebirth();
        }
        if (this.isSlime()) {
            return this.configValues.getAllowSlimeRebirth();
        }
        return true;
    }

    private boolean isSlime() {
        return this.livingEntity instanceof class_1621;
    }

    private boolean isBoss() {
        if (this.livingEntity instanceof class_1528 || this.livingEntity instanceof class_1510 || this.livingEntity instanceof class_1550) {
            return true;
        }
        if (this.livingEntity instanceof class_1463) {
            return ((class_1463)this.livingEntity).method_6610() == 99;
        }
        return false;
    }

    private boolean rebirthIsAllowedInBiome() {
        List<String> biomeList = this.mobSettings.getBiomeList();
        boolean biomeIsAllowed = biomeList.contains("*");
        class_2960 biomeId = this.getEntityBiomeId();
        if (biomeId != null && biomeList.contains(biomeId.toString().toLowerCase())) {
            biomeIsAllowed = !biomeIsAllowed;
        }
        return biomeIsAllowed;
    }

    @Nullable
    private class_2960 getEntityBiomeId() {
        class_1959 biome = this.livingEntity.method_5770().method_22385().method_22393(this.livingEntity.method_24515());
        return this.livingEntity.method_5770().method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
    }

    private int getMobCountToSpawn() {
        double rand = Math.random();
        int count = 0;
        if (rand <= this.mobSettings.getRebirthChance()) {
            ++count;
            count += this.getExtraMobCount();
        }
        return count;
    }

    private int getExtraMobCount() {
        String extraMobMode;
        if (this.mobSettings.getExtraMobCount() <= 0) {
            return 0;
        }
        double rand = Math.random();
        switch (extraMobMode = this.mobSettings.getExtraMobMode().toLowerCase()) {
            case "all": {
                if (rand <= this.mobSettings.getExtraMobChance()) {
                    return this.mobSettings.getExtraMobCount();
                }
                return 0;
            }
        }
        int extraCount = 0;
        for (int i = 0; i < this.mobSettings.getExtraMobCount(); ++i) {
            if (rand <= this.mobSettings.getExtraMobChance()) {
                ++extraCount;
            } else if (!extraMobMode.equals("per-mob")) break;
            rand = Math.random();
        }
        return extraCount;
    }

    private void triggerRebirth(int count) {
        for (int i = 0; i < count; ++i) {
            class_1299<?> rebornEntityType = this.getEntityTypeForRebirth();
            if (this.mobSettings.isRebornAsEggs()) {
                if (MainEntrypoint.spawnEggs.containsKey(rebornEntityType)) {
                    this.dropMobEgg(rebornEntityType);
                    continue;
                }
                MobRebirthConstants.LOGGER.error("Missing egg for " + class_2378.field_11145.method_10221(rebornEntityType));
                continue;
            }
            this.createEntity(rebornEntityType);
        }
    }

    private class_1299<?> getEntityTypeForRebirth() {
        HashMap rebornMobTypes = Maps.newHashMap(this.mobSettings.getRebornMobWeights());
        if (rebornMobTypes.isEmpty() || rebornMobTypes.size() == 1 && rebornMobTypes.containsKey("")) {
            return this.livingEntity.method_5864();
        }
        if (rebornMobTypes.containsKey("")) {
            int weight = (Integer)rebornMobTypes.remove("");
            rebornMobTypes.put(class_2378.field_11145.method_10221((Object)this.livingEntity.method_5864()).toString(), weight);
        }
        if (rebornMobTypes.size() == 1) {
            return (class_1299)class_2378.field_11145.method_10223(new class_2960((String)rebornMobTypes.keySet().toArray()[0]));
        }
        int total = rebornMobTypes.values().stream().mapToInt(Integer::valueOf).sum();
        int selected = this.livingEntity.method_6051().nextInt(total) + 1;
        ArrayList entries = Lists.newArrayList(rebornMobTypes.entrySet());
        Collections.shuffle(entries);
        for (Map.Entry entry : entries) {
            if ((selected -= ((Integer)entry.getValue()).intValue()) > 0) continue;
            return (class_1299)class_2378.field_11145.method_10223(new class_2960((String)entry.getKey()));
        }
        throw new IllegalStateException("Ran out of entries in the weighted list.");
    }

    private void dropMobEgg(class_1299<?> entityType) {
        this.livingEntity.method_5870(() -> (class_1792)MainEntrypoint.spawnEggs.get(entityType), 0);
    }

    private void createEntity(class_1299<?> entityType) {
        class_1937 worldIn = this.livingEntity.field_6002;
        class_2487 storedData = new class_2487();
        this.livingEntity.method_5652(storedData);
        class_1799 weapon = this.livingEntity.method_5998(class_1268.field_5808);
        class_1799 offhand = this.livingEntity.method_5998(class_1268.field_5810);
        class_1309 newEntity = (class_1309)entityType.method_5883(worldIn);
        if (newEntity == null) {
            return;
        }
        newEntity.method_5847(newEntity.method_36454());
        newEntity.method_5636(newEntity.method_36454());
        float health = newEntity.method_6063();
        storedData.method_10569("Health", (int)health);
        newEntity.method_5749(storedData);
        newEntity.method_6033(health);
        if (!weapon.method_7960()) {
            newEntity.method_5673(class_1304.field_6173, weapon);
        }
        if (!offhand.method_7960()) {
            newEntity.method_5673(class_1304.field_6171, offhand);
        }
        newEntity.method_30634((double)this.livingEntity.method_24515().method_10263(), (double)this.livingEntity.method_24515().method_10264(), (double)this.livingEntity.method_24515().method_10260());
        newEntity.method_5826(UUID.randomUUID());
        worldIn.method_8649((class_1297)newEntity);
    }

    private boolean isVanilla(class_1309 livingEntity) {
        return this.getId((class_1297)livingEntity).method_12836().equalsIgnoreCase("minecraft");
    }

    private class_2960 getId(class_1297 entity) {
        return class_2378.field_11145.method_10221((Object)entity.method_5864());
    }
}

