/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsGuiRenderer {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private List<Waypoint> sortingList;
    private WaypointFilterParams filterParams;
    private Predicate<Waypoint> filter;

    public WaypointsGuiRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.sortingList = new ArrayList<Waypoint>();
        this.filterParams = new WaypointFilterParams();
        this.filter = w -> {
            WaypointFilterParams filterParams = this.filterParams;
            boolean deathpoints = filterParams.deathpoints;
            if (w.isDisabled() || w.getType() == 1 && !deathpoints) {
                return false;
            }
            double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraX;
            double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraZ;
            double distance = Math.sqrt(offx * offx + offz * offz);
            double waypointsDistance = filterParams.waypointsDistance;
            return w.getType() != 0 || w.isGlobal() || waypointsDistance == 0.0 || !(distance > waypointsDistance);
        };
    }

    public void render(XaeroMinimapSession minimapSession, PoseStack matrixStack, MinimapRendererHelper rendererHelper, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double zoom, boolean circle, float minimapScale, MultiBufferSource.BufferSource renderTypeBuffer, boolean safeMode) {
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        VertexConsumer waypointBackgroundConsumer = renderTypeBuffer.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        Waypoint.RENDER_SORTING_POS = this.mc.f_91063_.m_109153_().m_90583_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, -980.0);
        if (this.modMain.getSettings().compassOverWaypoints) {
            this.drawWaypoints(waypointsManager, matrixStack, rendererHelper, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, renderTypeBuffer, waypointBackgroundConsumer);
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(matrixStack, rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, renderTypeBuffer, null);
            }
        } else {
            if (this.modMain.getSettings().compassLocation == 2 || safeMode) {
                this.drawCompass(matrixStack, rendererHelper, specW, specH, ps, pc, zoom, circle, minimapScale, false, renderTypeBuffer, null);
            }
            this.drawWaypoints(waypointsManager, matrixStack, rendererHelper, playerX, playerZ, specW, specH, ps, pc, partial, dimDiv, zoom, circle, minimapScale, renderTypeBuffer, waypointBackgroundConsumer);
        }
        matrixStack.m_85849_();
        renderTypeBuffer.m_109911_();
    }

    private void drawWaypoints(WaypointsManager waypointsManager, PoseStack matrixStack, MinimapRendererHelper rendererHelper, double playerX, double playerZ, int specW, int specH, double ps, double pc, float partial, double dimDiv, double zoom, boolean circle, float minimapScale, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        if (this.mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS) || this.mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_BENEFICIAL) || this.mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_HARMFUL)) {
            return;
        }
        List<Waypoint> sortingList = this.sortingList;
        sortingList.clear();
        if (this.modMain.getSettings().getShowWaypoints() && waypointsManager.getWaypoints() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    sortingList.addAll(setEntry.getValue().getList());
                }
            } else {
                sortingList.addAll(waypointsManager.getWaypoints().getList());
            }
        }
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints = WaypointsManager.customWaypoints;
        if (this.modMain.getSettings().getShowWaypoints() && !customWaypoints.isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        this.filterParams.setParams(playerX, 0.0, playerZ, null, dimDiv, this.modMain.getSettings().getDeathpoints(), this.modMain.getSettings().getMaxWaypointsDistance(), this.modMain.getSettings().waypointsDistanceMin, 0.0);
        Iterator<Waypoint> iterator = sortingList.stream().filter(this.filter).sorted().iterator();
        this.renderWaypointsIterator(matrixStack, rendererHelper, iterator, playerX, playerZ, specW, specH, ps, pc, dimDiv, zoom, circle, minimapScale, textRenderTypeBuffer, waypointBackgroundConsumer);
    }

    private void renderWaypointsIterator(PoseStack matrixStack, MinimapRendererHelper rendererHelper, Iterator<Waypoint> iter, double playerX, double playerZ, int specW, int specH, double ps, double pc, double dimDiv, double zoom, boolean circle, float minimapScale, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        while (iter.hasNext()) {
            Waypoint w = iter.next();
            double offx = (double)w.getX(dimDiv) + 0.5 - playerX;
            double offz = (double)w.getZ(dimDiv) + 0.5 - playerZ;
            matrixStack.m_85837_(0.0, 0.0, 0.1);
            this.translatePosition(matrixStack, specW, specH, ps, pc, offx, offz, zoom, circle);
            matrixStack.m_85841_(minimapScale, minimapScale, 1.0f);
            this.drawIconOnGUI(matrixStack, rendererHelper, w, this.modMain.getSettings(), 0, 0, textRenderTypeBuffer, waypointBackgroundConsumer);
            matrixStack.m_85849_();
        }
    }

    public void drawCompass(PoseStack matrixStack, MinimapRendererHelper rendererHelper, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer nameBgBuilder) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        String[] nesw = new String[]{I18n.m_118938_((String)"gui.xaero_compass_north", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_east", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_south", (Object[])new Object[0]), I18n.m_118938_((String)"gui.xaero_compass_west", (Object[])new Object[0])};
        int color = ModSettings.COLORS[this.modMain.getSettings().compassColor];
        GlStateManager.m_84110_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 4; ++i) {
            double offx;
            double d = i == 0 || i == 2 ? 0.0 : (offx = (double)(i == 1 ? 10000 : -10000));
            double offy = i == 1 || i == 3 ? 0.0 : (double)(i == 2 ? 10000 : -10000);
            matrixStack.m_85837_(0.0, 0.0, 2.0);
            this.translatePosition(matrixStack, specW, specH, ps, pc, offx, offy, zoom, circle);
            matrixStack.m_85841_(minimapScale, minimapScale, 1.0f);
            int halfW = this.mc.f_91062_.m_92895_(nesw[i]) / 2 - 1;
            if (background) {
                RenderSystem.m_69478_();
                RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_85861_(), nameBgBuilder, -4 - addedFrame, -4 - addedFrame, 9 + 2 * addedFrame, 9 + 2 * addedFrame, 0x90000000 | color & 0xFFFFFF);
                RenderSystem.m_69453_();
            }
            Misc.drawNormalText(matrixStack, nesw[i], -halfW + 1, -2.0f, color, false, textRenderTypeBuffer);
            matrixStack.m_85837_(0.0, 0.0, 1.0);
            Misc.drawNormalText(matrixStack, nesw[i], -halfW, -3.0f, -1, false, textRenderTypeBuffer);
            matrixStack.m_85849_();
        }
        matrixStack.m_85837_(0.0, 0.0, 2.0);
    }

    public void translatePosition(PoseStack matrixStack, int specW, int specH, double ps, double pc, double offx, double offy, double zoom, boolean circle) {
        double X;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
            }
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(Math.round(borderedX) - 1L), (double)(Math.round(borderedY) - 1L), 0.0);
    }

    public void drawIconOnGUI(PoseStack matrixStack, MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer) {
        int c = ModSettings.COLORS[w.getColor()];
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        int j = w.getType() == 1 ? 4 : Minecraft.m_91087_().f_91062_.m_92895_(w.getSymbol()) / 2;
        int addedFrame = j > 4 ? j - 4 : 0;
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4 - addedFrame;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5 + addedFrame;
        rendererHelper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_85861_(), waypointBackgroundConsumer, rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        matrixStack.m_85837_(0.0, 0.0, 0.05);
        if (w.getType() == 0) {
            Misc.drawNormalText(matrixStack, w.getSymbol(), drawX + 1 - j, drawY - 3, -1, true, renderTypeBuffer);
        } else if (w.getType() == 1) {
            RenderSystem.m_69482_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)InterfaceRenderer.guiTextures);
            RenderSystem.m_157429_((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.m_91087_().f_91065_.m_93228_(matrixStack, rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            RenderSystem.m_157429_((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.m_91087_().f_91065_.m_93228_(matrixStack, rectX1, rectY1, 0, 78, 9, 9);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSetChange(WaypointsManager waypointsManager, PoseStack matrixStack, Window res) {
        if (waypointsManager.getWaypoints() != null && waypointsManager.setChanged != 0L) {
            int passed = (int)(System.currentTimeMillis() - waypointsManager.setChanged);
            if (passed < 1500) {
                int fadeTime = 300;
                boolean fading = passed > 1500 - fadeTime;
                int alpha = 3 + (int)(252.0f * (fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f));
                int c = 0xFFFFFF | alpha << 24;
                MultiBufferSource.BufferSource textRenderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
                Misc.drawCenteredPiercingText(matrixStack, I18n.m_118938_((String)waypointsManager.getWaypoints().getName(), (Object[])new Object[0]), (float)(res.m_85445_() / 2), (float)(res.m_85446_() / 2 + 50), c, true, textRenderTypeBuffers);
                textRenderTypeBuffers.m_109911_();
                RenderSystem.m_69478_();
                RenderSystem.m_69405_((int)770, (int)771);
            } else {
                waypointsManager.setChanged = 0L;
            }
        }
    }
}

