/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ModelSupplier;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class Backpack {
    private final ResourceLocation id;

    public Backpack(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isUnlocked(Player player) {
        return UnlockTracker.get(player).map(impl -> impl.getUnlockedBackpacks().contains(this.id)).orElse(false) != false || (Boolean)Config.SERVER.unlockAllBackpacks.get() != false;
    }

    public void clientTick(Player player, Vec3 pos) {
    }

    public abstract ModelSupplier getModelSupplier();

    @Nullable
    protected IProgressTracker createProgressTracker() {
        return null;
    }
}

