/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.IMovedAccess;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import com.mrcrayfish.backpacked.common.backpack.WanderingBagBackpack;
import com.mrcrayfish.backpacked.common.data.PickpocketChallenge;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class WanderingTraderEvents {
    private static final Field goalsField = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"f_25345_");
    public static final TranslatableComponent WANDERING_BAG_TRANSLATION = new TranslatableComponent("backpacked.backpack.wandering_bag");

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity;
        if (!event.getWorld().m_5776_() && (entity = event.getEntity()) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (((Boolean)Config.COMMON.spawnBackpackOnWanderingTraders.get()).booleanValue()) {
                PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
                    if (!data.isInitialized()) {
                        boolean equipped = trader.f_19853_.f_46441_.nextInt((Integer)Config.COMMON.wanderingTraderBackpackChance.get()) == 0;
                        data.setBackpackEquipped(equipped);
                        data.setInitialized();
                    }
                });
                WanderingTraderEvents.patchTraderAiGoals(trader);
            }
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().m_6095_() != EntityType.f_20494_) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)event.getTarget();
        PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
            if (data.isBackpackEquipped()) {
                Network.getPlayChannel().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new MessageSyncVillagerBackpack(event.getTarget().m_142049_()));
            }
        });
    }

    @SubscribeEvent
    public void onTickLivingEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (level.m_5776_() || entity.m_6095_() != EntityType.f_20494_) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        if (trader.m_35303_() > 0) {
            trader.m_35319_(trader.m_35303_() - 1);
        }
        PickpocketChallenge.get(entity).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            Map<Player, Long> detectedPlayers = data.getDetectedPlayers();
            List<Player> newDetectedPlayers = this.findDetectedPlayers((LivingEntity)trader);
            newDetectedPlayers.forEach(player -> detectedPlayers.put((Player)player, level.m_46467_()));
            detectedPlayers.entrySet().removeIf(this.createForgetPlayerPredicate(trader, level));
            data.getDislikedPlayers().entrySet().removeIf(entry -> level.m_46467_() - (Long)entry.getValue() > (long)((Integer)Config.COMMON.dislikeCooldown.get()).intValue());
        });
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!entity.f_19853_.m_5776_() && entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (!((Boolean)Config.COMMON.dislikedPlayersCanTrade.get()).booleanValue() && PickpocketChallenge.get((LivingEntity)trader).map(data -> data.isBackpackEquipped() && data.isDislikedPlayer(event.getPlayer())).orElse(false).booleanValue()) {
                trader.m_35319_(20);
                trader.f_19853_.m_6269_(null, (Entity)trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private List<Player> findDetectedPlayers(LivingEntity entity) {
        return entity.f_19853_.m_142425_((EntityTypeTest)EntityType.f_20532_, entity.m_142469_().m_82400_(WanderingTraderEvents.getMaxDetectionDistance()), player -> WanderingTraderEvents.isPlayerInLivingEntityVision(entity, player) && WanderingTraderEvents.isPlayerSeenByLivingEntity(entity, player, (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()) || !player.m_6047_() && WanderingTraderEvents.isPlayerMoving(player));
    }

    private Predicate<Map.Entry<Player, Long>> createForgetPlayerPredicate(WanderingTrader trader, Level world) {
        return entry -> !((Player)entry.getKey()).m_6084_() || (double)((Player)entry.getKey()).m_20270_((Entity)trader) > (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get() * 2.0 || world.m_46467_() - (Long)entry.getValue() > (Long)Config.COMMON.wanderingTraderForgetTime.get() && (double)((Player)entry.getKey()).m_20270_((Entity)trader) >= (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get();
    }

    private static boolean isPlayerInLivingEntityVision(LivingEntity entity, Player player) {
        Vec3 between = entity.m_20182_().m_82546_(player.m_20182_());
        float angle = (float)Math.toDegrees(Mth.m_14136_((double)between.f_82481_, (double)between.f_82479_)) - 90.0f;
        return Mth.m_14145_((float)(entity.f_20885_ + 180.0f), (float)angle) <= 90.0f;
    }

    private static boolean isPlayerSeenByLivingEntity(LivingEntity entity, Player player, double distance) {
        Vec3 playerEyePos;
        if (entity.f_19853_ != player.f_19853_ || (double)entity.m_20270_((Entity)player) > distance) {
            return false;
        }
        Vec3 livingEyePos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (WanderingTraderEvents.performRayTrace(livingEyePos, playerEyePos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_()), (Entity)entity).m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        Vec3 playerLegPos = new Vec3(player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_());
        return WanderingTraderEvents.performRayTrace(livingEyePos, playerLegPos, (Entity)entity).m_6662_() == HitResult.Type.MISS;
    }

    private static BlockHitResult performRayTrace(Vec3 start, Vec3 end, Entity source) {
        return source.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
    }

    private static boolean isPlayerMoving(Player player) {
        return ((IMovedAccess)player).backpackedMoved();
    }

    public static void openBackpack(WanderingTrader trader, ServerPlayer openingPlayer) {
        PickpocketChallenge.get((LivingEntity)trader).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (data.getDetectedPlayers().containsKey(openingPlayer)) {
                trader.m_35319_(20);
                trader.m_21563_().m_24964_(openingPlayer.m_20299_(1.0f));
                trader.f_19853_.m_6269_(null, (Entity)trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
                trader.f_19853_.m_142425_((EntityTypeTest)EntityType.f_20488_, trader.m_142469_().m_82400_(((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).doubleValue()), entity -> true).forEach(llama -> llama.m_6710_((LivingEntity)openingPlayer));
                ((ServerLevel)trader.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, trader.m_20185_(), trader.m_20188_(), trader.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                data.addDislikedPlayer((Player)openingPlayer, trader.f_19853_.m_46467_());
                return;
            }
            if (WanderingTraderEvents.generateBackpackLoot(trader, data)) {
                UnlockTracker.get((Player)openingPlayer).ifPresent(unlockTracker -> unlockTracker.getProgressTracker(WanderingBagBackpack.ID).ifPresent(tracker -> ((WanderingBagBackpack.PickpocketProgressTracker)tracker).addTrader(trader, openingPlayer)));
            }
            NetworkHooks.openGui((ServerPlayer)openingPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, entity1) -> new BackpackContainerMenu(id, entity1.m_150109_(), (Container)trader.m_141944_(), 8, 1, false), (Component)WANDERING_BAG_TRANSLATION), buffer -> {
                buffer.m_130130_(8);
                buffer.m_130130_(1);
                buffer.writeBoolean(false);
            });
            openingPlayer.f_19853_.m_6263_((Player)openingPlayer, trader.m_20185_(), trader.m_20186_() + 1.0, trader.m_20189_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 0.15f, 1.0f);
        });
    }

    private static boolean generateBackpackLoot(WanderingTrader trader, PickpocketChallenge data) {
        if (!data.isLootSpawned()) {
            int count = trader.f_19853_.f_46441_.nextInt(2) + 6;
            List randomSlotIndexes = IntStream.range(0, 8).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(randomSlotIndexes);
            MerchantOffers offers = trader.m_6616_();
            for (int i = 0; i < 8; ++i) {
                if (i < count) {
                    MerchantOffer offer = (MerchantOffer)offers.get(trader.f_19853_.f_46441_.nextInt(offers.size()));
                    ItemStack loot = offer.m_45368_().m_41777_();
                    loot.m_41764_(Mth.m_14045_((int)(loot.m_41613_() * (trader.f_19853_.f_46441_.nextInt((Integer)Config.COMMON.maxLootMultipler.get()) + 1)), (int)0, (int)64));
                    trader.m_141944_().m_6836_(((Integer)randomSlotIndexes.get(i)).intValue(), loot);
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)Items.f_42616_, trader.f_19853_.f_46441_.nextInt((Integer)Config.COMMON.maxEmeraldStack.get()) + 1);
                trader.m_141944_().m_6836_(((Integer)randomSlotIndexes.get(i)).intValue(), stack);
            }
            data.setLootSpawned();
            return true;
        }
        return false;
    }

    private static void patchTraderAiGoals(WanderingTrader trader) {
        try {
            Set goals = (Set)goalsField.get(trader.f_21345_);
            if (goals != null) {
                goals.removeIf(goal -> goal.m_26015_() instanceof LookAtPlayerGoal);
            }
            trader.f_21345_.m_25352_(2, (Goal)new LootAtDetectedPlayerGoal(trader));
            trader.f_21345_.m_25352_(9, (Goal)new PickpocketLookAtPlayerGoal((Mob)trader, Player.class, 3.0f, 1.0f));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static double getMaxDetectionDistance() {
        return (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get();
    }

    private static class LootAtDetectedPlayerGoal
    extends LookAtPlayerGoal {
        private final WanderingTrader trader;

        public LootAtDetectedPlayerGoal(WanderingTrader trader) {
            super((Mob)trader, Player.class, ((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0f, 1.0f);
            this.trader = trader;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            super.m_8036_();
            if (this.trader.m_142581_() == null && this.f_25513_ instanceof Player) {
                PickpocketChallenge data = PickpocketChallenge.get((LivingEntity)this.trader).orElse(null);
                return data != null && data.isBackpackEquipped() && data.getDetectedPlayers().containsKey((Player)this.f_25513_);
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.f_25513_ instanceof Player && (double)this.f_25513_.m_20270_((Entity)this.trader) <= (double)((Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get()).floatValue() * 2.0) {
                PickpocketChallenge data = PickpocketChallenge.get((LivingEntity)this.trader).orElse(null);
                return data != null && data.getDetectedPlayers().containsKey((Player)this.f_25513_);
            }
            return false;
        }

        public void m_8056_() {
            if (this.trader.f_19853_ instanceof ServerLevel && PickpocketChallenge.get((LivingEntity)this.trader).map(data -> data.isDislikedPlayer((Player)this.f_25513_)).orElse(false).booleanValue()) {
                ((ServerLevel)this.trader.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.trader.m_20185_(), this.trader.m_20188_(), this.trader.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                this.trader.f_19853_.m_6269_(null, (Entity)this.trader, SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.5f);
            }
        }

        public void m_8037_() {
            if (WanderingTraderEvents.isPlayerSeenByLivingEntity((LivingEntity)this.trader, (Player)this.f_25513_, (Double)Config.COMMON.wanderingTraderMaxDetectionDistance.get() * 2.0)) {
                this.trader.m_21563_().m_24946_(this.f_25513_.m_20185_(), this.f_25513_.m_20188_(), this.f_25513_.m_20189_());
            }
        }
    }

    private static class PickpocketLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public PickpocketLookAtPlayerGoal(Mob entity, Class<? extends LivingEntity> entityClass, float distance, float probability) {
            super(entity, entityClass, distance, probability);
        }

        public boolean m_8036_() {
            if (PickpocketChallenge.get((LivingEntity)this.f_25512_).map(PickpocketChallenge::isBackpackEquipped).orElse(false).booleanValue()) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

