/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.item.BackpackItem;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class Curios {
    public static ItemStack getBackpackStack(Player player) {
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.f_41583_);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> {
                ItemStack stack = stacksHandler.getStacks().getStackInSlot(0);
                if (stack.m_41720_() instanceof BackpackItem) {
                    backpack.set(stack);
                }
            });
        });
        return backpack.get();
    }

    public static void setBackpackStack(Player player, ItemStack stack) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> stacksHandler.getStacks().setStackInSlot(0, stack.m_41777_()));
        });
    }

    public static boolean isBackpackVisible(Player player) {
        AtomicReference<Boolean> visible = new AtomicReference<Boolean>(true);
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        optional.ifPresent(itemHandler -> {
            Optional stacksOptional = itemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier());
            stacksOptional.ifPresent(stacksHandler -> visible.set((Boolean)stacksHandler.getRenders().get(0)));
        });
        return visible.get();
    }

    public static ICapabilityProvider createBackpackProvider(final ItemStack stack) {
        return CurioItemCapability.createProvider((ICurio)new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            @Nonnull
            public ICurio.SoundInfo getEquipSound(SlotContext context) {
                return new ICurio.SoundInfo(SoundEvents.f_11678_, 1.0f, 1.0f);
            }

            public boolean canEquipFromUse(SlotContext context) {
                return true;
            }

            public boolean canSync(SlotContext context) {
                return true;
            }

            public boolean canUnequip(SlotContext context) {
                if (!((Boolean)Config.SERVER.lockBackpackIntoSlot.get()).booleanValue()) {
                    return true;
                }
                CompoundTag tag = stack.m_41783_();
                return tag == null || tag.m_128437_("Items", 10).isEmpty();
            }

            @Nonnull
            public ICurio.DropRule getDropRule(SlotContext context, DamageSource source, int lootingLevel, boolean recentlyHit) {
                return (Boolean)Config.COMMON.keepBackpackOnDeath.get() != false ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.DEFAULT;
            }
        });
    }
}

