/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackInventory
extends SimpleContainer {
    private final Player player;
    private final ItemStack stack;

    public BackpackInventory(int cols, int rows, Player player, ItemStack stack) {
        super(rows * cols);
        this.player = player;
        this.stack = stack;
        this.loadBackpackContents(player);
    }

    private void loadBackpackContents(Player player) {
        CompoundTag compound = this.stack.m_41784_();
        if (compound.m_128425_("Items", 9)) {
            InventoryHelper.loadAllItems(compound.m_128437_("Items", 10), this, player.f_19853_, player.m_20182_());
        }
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public boolean m_6542_(Player player) {
        return Backpacked.getBackpackStack(this.player).equals(this.stack) && (this.player.equals((Object)player) || PickpocketUtil.canPickpocketEntity((LivingEntity)this.player, player, (Double)Config.SERVER.pickpocketMaxReachDistance.get() + 0.5));
    }

    public void m_6596_() {
        super.m_6596_();
        CompoundTag compound = this.stack.m_41784_();
        compound.m_128365_("Items", (Tag)InventoryHelper.saveAllItems(new ListTag(), this));
    }
}

