/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainerMenu;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.NetworkHooks;

public class BackpackItem
extends Item {
    public static final TranslatableComponent BACKPACK_TRANSLATION = new TranslatableComponent("container.backpack");
    public static final MutableComponent REMOVE_ITEMS_TOOLTIP = new TranslatableComponent("backpacked.tooltip.remove_items").m_130940_(ChatFormatting.RED);

    public BackpackItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ExtendedPlayerInventory inventory;
        ItemStack heldItem = playerIn.m_21120_(handIn);
        Inventory inventory2 = playerIn.m_150109_();
        if (inventory2 instanceof ExtendedPlayerInventory && ((ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41619_()) {
            inventory.m_6836_(41, heldItem.m_41777_());
            heldItem.m_41764_(0);
            playerIn.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (!Backpacked.isCuriosLoaded()) {
            return null;
        }
        return Curios.createBackpackProvider(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        ClientHandler.createBackpackTooltip(stack, list);
    }

    public static boolean openBackpack(ServerPlayer ownerPlayer, ServerPlayer openingPlayer) {
        ItemStack backpack = Backpacked.getBackpackStack((Player)ownerPlayer);
        if (!backpack.m_41619_()) {
            BackpackInventory backpackInventory = ((BackpackedInventoryAccess)ownerPlayer).getBackpackedInventory();
            if (backpackInventory == null) {
                return false;
            }
            BackpackItem backpackItem = (BackpackItem)backpack.m_41720_();
            TranslatableComponent title = backpack.m_41788_() ? backpack.m_41786_() : BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            NetworkHooks.openGui((ServerPlayer)openingPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, entity) -> new BackpackContainerMenu(id, openingPlayer.m_150109_(), (Container)backpackInventory, cols, rows, owner), (Component)title), buffer -> {
                buffer.m_130130_(cols);
                buffer.m_130130_(rows);
                buffer.writeBoolean(owner);
            });
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return (Integer)Config.COMMON.backpackInventorySizeColumns.get();
    }

    public int getRowCount() {
        return (Integer)Config.COMMON.backpackInventorySizeRows.get();
    }

    public Supplier<BackpackModel> getDefaultModel() {
        return () -> ClientHandler.getModelInstances().getStandardModel();
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag realTag = stack.m_41784_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("BackpackModel", realTag.m_128461_("BackpackModel"));
        for (BackpackModelProperty property : BackpackModelProperty.values()) {
            String tagName = property.getTagName();
            boolean value = realTag.m_128425_(tagName, 1) ? realTag.m_128471_(tagName) : property.getDefaultValue();
            tag.m_128379_(tagName, value);
        }
        tag.m_128365_("Enchantments", (Tag)stack.m_41785_());
        tag.m_128365_("display", (Tag)stack.m_41698_("display"));
        return tag;
    }
}

