/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import com.mrcrayfish.backpacked.Config;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PickpocketUtil {
    public static Vec3 getEntityPos(Entity entity, float partialTick) {
        double x = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_());
        return new Vec3(x, y, z);
    }

    public static AABB getBackpackBox(LivingEntity entity, float partialTick) {
        AABB backpackBox = new AABB(-0.25, 0.0, -0.25, 0.25, 0.5625, 0.25);
        backpackBox = backpackBox.m_82383_(PickpocketUtil.getEntityPos((Entity)entity, partialTick));
        backpackBox = backpackBox.m_82386_(0.0, entity.m_20089_() != Pose.SWIMMING ? 0.875 : 0.3125, 0.0);
        if (entity.m_20089_() == Pose.CROUCHING) {
            backpackBox = backpackBox.m_82386_(0.0, -0.1875, 0.0);
        }
        float bodyRotation = Mth.m_14179_((float)partialTick, (float)entity.f_20884_, (float)entity.f_20883_);
        backpackBox = backpackBox.m_82383_(Vec3.m_82498_((float)0.0f, (float)(bodyRotation + 180.0f)).m_82490_(entity.m_20089_() != Pose.SWIMMING ? 0.3125 : -0.125));
        return backpackBox;
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, Player thiefPlayer) {
        return PickpocketUtil.canPickpocketEntity(targetEntity, thiefPlayer, (Double)Config.SERVER.pickpocketMaxReachDistance.get());
    }

    public static boolean canPickpocketEntity(LivingEntity targetEntity, Player thiefPlayer, double range) {
        return PickpocketUtil.inRangeOfBackpack(targetEntity, thiefPlayer) && PickpocketUtil.inReachOfBackpack(targetEntity, thiefPlayer, range);
    }

    public static boolean inRangeOfBackpack(LivingEntity livingEntity, Player thiefPlayer) {
        if (livingEntity.m_20089_() == Pose.SWIMMING) {
            return true;
        }
        Vec3 between = PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f).m_82546_(PickpocketUtil.getEntityPos((Entity)livingEntity, 1.0f));
        float angle = (float)Math.toDegrees(Math.atan2(between.f_82481_, between.f_82479_)) - 90.0f;
        float difference = Mth.m_14145_((float)(livingEntity.f_20883_ + 180.0f), (float)angle);
        return (double)difference <= (Double)Config.SERVER.pickpocketMaxRangeAngle.get();
    }

    public static boolean inReachOfBackpack(LivingEntity targetPlayer, Player thiefPlayer, double reachDistance) {
        Vec3 pos = PickpocketUtil.getEntityPos((Entity)targetPlayer, 1.0f);
        pos = pos.m_82549_(Vec3.m_82498_((float)0.0f, (float)(targetPlayer.f_20883_ + 180.0f)).m_82490_(targetPlayer.m_20089_() != Pose.SWIMMING ? 0.3125 : -0.125));
        return pos.m_82554_(PickpocketUtil.getEntityPos((Entity)thiefPlayer, 1.0f)) <= reachDistance;
    }

    public static boolean canSeeBackpack(LivingEntity targetEntity, Player thiefPlayer) {
        Vec3 end;
        Vec3 start;
        if ((double)targetEntity.m_20270_((Entity)thiefPlayer) > 4.0) {
            return false;
        }
        AABB backpackBox = PickpocketUtil.getBackpackBox(targetEntity, 1.0f);
        Optional hitPos = backpackBox.m_82371_(start = thiefPlayer.m_20299_(1.0f), end = thiefPlayer.m_20252_(1.0f).m_82490_(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue()).m_82549_(start));
        if (!hitPos.isPresent()) {
            return false;
        }
        BlockHitResult result = thiefPlayer.f_19853_.m_45547_(new ClipContext(start, (Vec3)hitPos.get(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)thiefPlayer));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return true;
        }
        return start.m_82554_((Vec3)hitPos.get()) < start.m_82554_(result.m_82450_());
    }
}

