/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.Configuration;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="biomeinfo", value={Dist.CLIENT})
public class BiomeInfoRenderer {
    public static final IIngameOverlay OVERLAY = OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.HUD_TEXT_ELEMENT, (String)"biomeinfo:overlay", BiomeInfoRenderer::renderBiomeInfo);
    public static Biome previousBiome;
    public static int displayTime;
    public static int alpha;
    public static boolean complete;
    public static boolean fadingIn;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (complete) {
            if (!fadingIn) {
                if (!Configuration.fadeOut() && alpha != 255) {
                    alpha = 255;
                } else if (Configuration.fadeOut()) {
                    if (displayTime > 0) {
                        --displayTime;
                    } else if (alpha > 0) {
                        alpha -= 10;
                    }
                }
            } else if ((alpha += 10) >= 255) {
                fadingIn = false;
                displayTime = Configuration.displayTime();
                alpha = 255;
            }
        }
    }

    public static void renderBiomeInfo(ForgeIngameGui gui, PoseStack matrix, float partialTicks, int width, int height) {
        if (complete && Configuration.enabled() && (!Configuration.hideOnDebugScreen() || !Minecraft.m_91087_().f_91066_.f_92063_)) {
            Minecraft mc = Minecraft.m_91087_();
            BlockPos pos = mc.m_91288_().m_142538_();
            if (mc.f_91073_ != null && mc.f_91073_.m_46749_(pos)) {
                Biome biome = mc.f_91073_.m_46857_(pos);
                if (previousBiome != biome) {
                    previousBiome = biome;
                    if (Configuration.fadeIn()) {
                        displayTime = 0;
                        alpha = 0;
                        fadingIn = true;
                    } else {
                        displayTime = Configuration.displayTime();
                        alpha = 255;
                    }
                }
                if (alpha > 0) {
                    float scale = (float)Configuration.scale();
                    TranslatableComponent biomeName = new TranslatableComponent(Util.m_137492_((String)"biome", (ResourceLocation)mc.f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome)));
                    matrix.m_85836_();
                    matrix.m_85841_(scale, scale, scale);
                    if (!Configuration.textShadow()) {
                        mc.f_91062_.m_92889_(matrix, (Component)biomeName, (float)Configuration.posX(), (float)Configuration.posY(), Configuration.color() | alpha << 24);
                    } else {
                        mc.f_91062_.m_92763_(matrix, (Component)biomeName, (float)Configuration.posX(), (float)Configuration.posY(), Configuration.color() | alpha << 24);
                    }
                    matrix.m_85849_();
                }
            }
        }
    }

    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        complete = true;
    }

    public static void onModConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == Configuration.CONFIG_SPEC) {
            OverlayRegistry.enableOverlay((IIngameOverlay)OVERLAY, (boolean)Configuration.enabled());
        }
    }

    static {
        displayTime = 0;
        alpha = 0;
        complete = false;
        fadingIn = false;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BiomeInfoRenderer::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BiomeInfoRenderer::onModConfigReloading);
    }
}

