/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ForgeConfigSpec CONFIG_SPEC;
    private static final Configuration CONFIG;
    public final ForgeConfigSpec.BooleanValue enabled;
    public final ForgeConfigSpec.BooleanValue fadeOut;
    public final ForgeConfigSpec.BooleanValue fadeIn;
    public final ForgeConfigSpec.IntValue displayTime;
    public final ForgeConfigSpec.IntValue posX;
    public final ForgeConfigSpec.IntValue posY;
    public final ForgeConfigSpec.DoubleValue scale;
    public final ForgeConfigSpec.BooleanValue textShadow;
    public final ForgeConfigSpec.IntValue color;
    public final ForgeConfigSpec.BooleanValue hideOnDebugScreen;

    Configuration(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("true if the biome info should be shown, false otherwise").define("enabled", true);
        this.fadeOut = builder.comment("true if the biome info should fade out shortly after a different biome has been entered. If this is set to false, the biome info will stay visible").define("fadeOut", true);
        this.fadeIn = builder.comment("true if the biome info should fade in when a different biome has been entered").define("fadeIn", true);
        this.displayTime = builder.comment("How long in ticks (20 ticks = 1 second) to display the biome info, if fadeOut = true. If fadeIn = true, the time will be counted from the moment the biome info has finished fading in.").defineInRange("displayTime", 30, 0, Integer.MAX_VALUE);
        this.posX = builder.comment("The X position to display the biome info at").defineInRange("posX", 3, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.posY = builder.comment("The Y position to display the biome info at").defineInRange("posY", 3, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.scale = builder.comment("The size of the biome info (multiplier)").defineInRange("scale", 1.0, 0.0, Double.MAX_VALUE);
        this.textShadow = builder.comment("true if the biome info should be rendered with a shadow, false otherwise").define("textShadow", true);
        this.color = builder.comment("The color to display the biome info in (Format: 0xRRGGBB)").defineInRange("color", 0xFFFFFF, 0, 0xFFFFFF);
        this.hideOnDebugScreen = builder.comment("If true, hides the mod's info text when the debug screen (F3) is open.").define("hideOnDebugScreen", true);
    }

    public static boolean enabled() {
        return (Boolean)Configuration.CONFIG.enabled.get();
    }

    public static boolean fadeOut() {
        return (Boolean)Configuration.CONFIG.fadeOut.get();
    }

    public static boolean fadeIn() {
        return (Boolean)Configuration.CONFIG.fadeIn.get();
    }

    public static int displayTime() {
        return (Integer)Configuration.CONFIG.displayTime.get();
    }

    public static int posX() {
        return (Integer)Configuration.CONFIG.posX.get();
    }

    public static int posY() {
        return (Integer)Configuration.CONFIG.posY.get();
    }

    public static double scale() {
        return (Double)Configuration.CONFIG.scale.get();
    }

    public static boolean textShadow() {
        return (Boolean)Configuration.CONFIG.textShadow.get();
    }

    public static int color() {
        return (Integer)Configuration.CONFIG.color.get();
    }

    public static boolean hideOnDebugScreen() {
        return (Boolean)Configuration.CONFIG.hideOnDebugScreen.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Configuration)specPair.getLeft();
    }
}

