/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker;

import java.util.Collection;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.api.client.events.v0.ClothClientHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_259;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_485;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import red.jackf.chesttracker.config.ChestTrackerConfig;
import red.jackf.chesttracker.gui.ChestTrackerButtonWidget;
import red.jackf.chesttracker.gui.ItemListScreen;
import red.jackf.chesttracker.memory.Memory;
import red.jackf.chesttracker.memory.MemoryDatabase;
import red.jackf.chesttracker.memory.MemoryUtils;
import red.jackf.chesttracker.resource.ButtonPositionManager;
import red.jackf.whereisit.WhereIsItClient;
import red.jackf.whereisit.client.PositionData;
import red.jackf.whereisit.client.RenderUtils;

@Environment(value=EnvType.CLIENT)
public class ChestTracker
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"ChestTracker");
    public static final String MODID = "chesttracker";
    public static final class_304 GUI_KEY = new class_304("key.chesttracker.opengui", class_3675.class_307.field_1668, -1, "key.categories.chesttracker");
    public static final ChestTrackerConfig CONFIG = (ChestTrackerConfig)AutoConfig.register(ChestTrackerConfig.class, JanksonConfigSerializer::new).getConfig();

    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }

    public static void sendDebugMessage(class_2561 text) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_9203((class_2561)new class_2585("[ChestTracker] ").method_27692(class_124.field_1054).method_10852(text), class_156.field_25140);
        }
    }

    public static void searchForItem(@NotNull class_1799 stack) {
        MemoryDatabase database = MemoryDatabase.getCurrent();
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (database != null && world != null) {
            ChestTracker.startRenderingForLocations(database.findItems(stack, world.method_27983().method_29177()));
        }
    }

    public static void startRenderingForLocations(Collection<Memory> memories) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world != null && memories.size() >= 1) {
            float r = (float)(ChestTracker.CONFIG.visualOptions.borderColour >> 16 & 0xFF) / 255.0f;
            float g = (float)(ChestTracker.CONFIG.visualOptions.borderColour >> 8 & 0xFF) / 255.0f;
            float b = (float)(ChestTracker.CONFIG.visualOptions.borderColour & 0xFF) / 255.0f;
            WhereIsItClient.handleFoundItems(memories.stream().map(memory -> new PositionData(memory.getPosition(), world.method_8510(), class_259.method_1077(), r, g, b, null)).toList());
            if (player != null) {
                player.method_7346();
            }
        }
    }

    public static int getSquareSearchRange() {
        int blockValue = ChestTracker.sliderValueToRange(ChestTracker.CONFIG.miscOptions.searchRange);
        if (blockValue == Integer.MAX_VALUE) {
            return blockValue;
        }
        return blockValue * blockValue;
    }

    public static int sliderValueToRange(int sliderValue) {
        if (sliderValue <= 16) {
            return 15 + sliderValue;
        }
        if (sliderValue <= 32) {
            return 30 + (sliderValue - 16) * 2;
        }
        if (sliderValue <= 48) {
            return 60 + (sliderValue - 32) * 4;
        }
        if (sliderValue <= 64) {
            return 120 + (sliderValue - 48) * 8;
        }
        if (sliderValue <= 80) {
            return 240 + (sliderValue - 64) * 16;
        }
        if (sliderValue <= 97) {
            return 480 + (sliderValue - 80) * 32;
        }
        return Integer.MAX_VALUE;
    }

    public static void drawLabels(WorldRenderContext context) {
        MemoryDatabase database = MemoryDatabase.getCurrent();
        if (database == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            Collection<Memory> toRender = database.getNamedMemories(mc.field_1687.method_27983().method_29177());
            for (Memory memory : toRender) {
                class_2338 blockPos = memory.getPosition();
                if (blockPos == null || memory.getTitle() == null || RenderUtils.FOUND_ITEM_POSITIONS.containsKey(blockPos)) continue;
                class_243 pos = class_243.method_24954((class_2382)blockPos);
                if (memory.getNameOffset() != null) {
                    pos = pos.method_1019(memory.getNameOffset());
                }
                RenderUtils.drawTextWithBackground((WorldRenderContext)context, (class_243)pos, (class_2561)memory.getTitle(), (int)ChestTracker.CONFIG.visualOptions.nameRenderRange);
            }
        }
    }

    public void onInitializeClient() {
        KeyBindingHelper.registerKeyBinding((class_304)GUI_KEY);
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            MemoryDatabase database = MemoryDatabase.getCurrent();
            if (database != null) {
                database.save();
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(ChestTracker::drawLabels);
        WhereIsItClient.SEARCH_FOR_ITEM.register((item, matchNbt, compoundTag) -> {
            class_1799 stack = new class_1799((class_1935)item);
            if (matchNbt) {
                stack.method_7980(compoundTag);
            }
            ChestTracker.searchForItem(stack);
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (GUI_KEY.method_1436() && client.field_1687 != null && client.field_1755 == null) {
                client.method_1507((class_437)new ItemListScreen());
            }
        });
        ClientTickEvents.END_WORLD_TICK.register(MemoryUtils::checkValidCycle);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ButtonPositionManager());
        ClothClientHooks.SCREEN_INIT_POST.register((minecraftClient, screen, screenHooks) -> {
            if (screen instanceof class_465 && ChestTracker.CONFIG.visualOptions.enableButton) {
                screenHooks.cloth$addDrawableChild((class_364)new ChestTrackerButtonWidget((class_465)screen, this.shouldDeleteBeEnabled()));
            }
        });
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            if (world.field_9236) {
                class_2248 hit = world.method_8320(blockHitResult.method_17777()).method_26204();
                if (MemoryUtils.isValidInventoryHolder(hit, world, blockHitResult.method_17777())) {
                    MemoryUtils.setLatestPos(blockHitResult.method_17777());
                    MemoryUtils.setWasEnderchest(hit == class_2246.field_10443);
                } else {
                    MemoryUtils.setLatestPos(null);
                    MemoryUtils.setWasEnderchest(false);
                }
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (world.field_9236) {
                MemoryUtils.setLatestPos(null);
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (world.field_9236) {
                MemoryUtils.setLatestPos(null);
            }
            return class_1271.method_22430((Object)class_1799.field_8037);
        });
    }

    private boolean shouldDeleteBeEnabled() {
        return MemoryUtils.getLatestPos() != null && !(class_310.method_1551().field_1755 instanceof class_485);
    }
}

