/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import red.jackf.chesttracker.ChestTracker;

@Environment(value=EnvType.CLIENT)
public class GsonHandler {
    private static final Gson GSON;

    private GsonHandler() {
    }

    public static Gson get() {
        return GSON;
    }

    static {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(class_2338.class, (Object)new BlockPosSerializer()).registerTypeAdapter(class_2960.class, (Object)new IdentifierSerializer()).registerTypeHierarchyAdapter(class_2561.class, (Object)new class_2561.class_2562()).registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584()).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).enableComplexMapKeySerialization();
        if (ChestTracker.CONFIG.databaseOptions.readableFiles) {
            builder.setPrettyPrinting();
        }
        GSON = builder.create();
    }

    private static class BlockPosSerializer
    implements JsonSerializer<class_2338>,
    JsonDeserializer<class_2338> {
        private BlockPosSerializer() {
        }

        public class_2338 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray array = json.getAsJsonArray();
            return new class_2338(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
        }

        public JsonElement serialize(class_2338 src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray array = new JsonArray();
            array.add((Number)src.method_10263());
            array.add((Number)src.method_10264());
            array.add((Number)src.method_10260());
            return array;
        }
    }

    private static class IdentifierSerializer
    implements JsonSerializer<class_2960>,
    JsonDeserializer<class_2960> {
        private IdentifierSerializer() {
        }

        public class_2960 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new class_2960(json.getAsJsonPrimitive().getAsString());
        }

        public JsonElement serialize(class_2960 src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }

    private static class ItemStackSerializer
    implements JsonSerializer<class_1799>,
    JsonDeserializer<class_1799> {
        private ItemStackSerializer() {
        }

        public class_1799 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject object = json.getAsJsonObject();
                class_2960 id = (class_2960)context.deserialize(object.get("id"), class_2960.class);
                int count = object.getAsJsonPrimitive("count").getAsInt();
                class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10223(id), count);
                JsonPrimitive tagJson = object.getAsJsonPrimitive("tag");
                if (tagJson != null) {
                    stack.method_7980(class_2522.method_10718((String)tagJson.getAsString()));
                }
                return stack;
            }
            catch (Exception ex) {
                throw new JsonParseException("Could not read item", (Throwable)ex);
            }
        }

        public JsonElement serialize(class_1799 src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.add("id", context.serialize((Object)class_2378.field_11142.method_10221((Object)src.method_7909())));
            object.addProperty("count", (Number)src.method_7947());
            class_2487 tag = src.method_7969();
            if (tag != null) {
                object.addProperty("tag", tag.toString());
            }
            return object;
        }
    }
}

