/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.compat;

import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1735;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;

public abstract class AppliedEnergisticsHandler {
    @Nullable
    private static Class<?> SLOT_CLASS = null;

    private static Optional<Class<?>> getClassIfExists(String name) {
        try {
            return Optional.of(Class.forName(name));
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }

    public static boolean isAE2Slot(class_1735 slot) {
        return SLOT_CLASS != null && SLOT_CLASS.isInstance(slot);
    }

    static {
        if (FabricLoader.getInstance().isModLoaded("appliedenergistics2")) {
            Optional<Class<?>> yarnName = AppliedEnergisticsHandler.getClassIfExists("appeng.container.slot.AppEngSlot");
            if (yarnName.isEmpty()) {
                Optional<Class<?>> mojangName = AppliedEnergisticsHandler.getClassIfExists("appeng.menu.slot.AppEngSlot");
                if (mojangName.isPresent()) {
                    SLOT_CLASS = mojangName.get();
                } else {
                    ChestTracker.LOGGER.warn("AE2 loaded but could not find slot class.");
                }
            } else {
                SLOT_CLASS = yarnName.get();
            }
        }
    }
}

