/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_344;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.gui.ButtonPositions;
import red.jackf.chesttracker.gui.ItemListScreen;
import red.jackf.chesttracker.memory.MemoryDatabase;
import red.jackf.chesttracker.memory.MemoryUtils;

@Environment(value=EnvType.CLIENT)
public class ChestTrackerButtonWidget
extends class_344 {
    private static final class_2960 TEXTURE_MAIN = ChestTracker.id("textures/gui_button_small.png");
    private static final class_2960 TEXTURE_FORGET = ChestTracker.id("textures/forget_button.png");
    private static final class_2960 TEXTURE_REMEMBER = ChestTracker.id("textures/remember_button.png");
    private static final class_2960 BACKGROUND_TEXTURE = ChestTracker.id("textures/gui_button_background.png");
    private static final class_2960 NAME_EDIT_TEXTURE = ChestTracker.id("textures/text_button.png");
    private final class_465<?> screen;
    private final boolean forgetOrRememberEnabled;
    private boolean isRemembered = false;

    public ChestTrackerButtonWidget(class_465<?> screen, boolean forgetOrRememberEnabled) {
        super(0, 0, 9, 9, 0, 0, 9, TEXTURE_MAIN, 9, 18, buttonRaw -> {
            class_310 client = class_310.method_1551();
            ChestTrackerButtonWidget button = (ChestTrackerButtonWidget)buttonRaw;
            if (button.shouldShowAltButton()) {
                MemoryDatabase database = MemoryDatabase.getCurrent();
                class_2338 pos = MemoryUtils.getLatestPos();
                if (database != null && client.field_1687 != null && pos != null) {
                    if (button.shouldShowRememberButton()) {
                        ChestTracker.sendDebugMessage((class_2561)new class_2588("chesttracker.remembered_new_location"));
                        MemoryUtils.setForceNextMerge(true);
                    } else {
                        if (MemoryUtils.wasLastEnderchest()) {
                            database.removePos(MemoryUtils.ENDER_CHEST_ID, class_2338.field_10980);
                            ChestTracker.sendDebugMessage((class_2561)new class_2588("chesttracker.forgot_ender_chest"));
                        } else {
                            Collection<class_2338> connected = MemoryUtils.getConnected((class_1937)client.field_1687, pos);
                            connected.forEach(connectedPos -> database.removePos(client.field_1687.method_27983().method_29177(), (class_2338)connectedPos));
                            database.removePos(client.field_1687.method_27983().method_29177(), pos);
                            ChestTracker.sendDebugMessage((class_2561)new class_2588("chesttracker.forgot_location", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
                        }
                        MemoryUtils.ignoreNextMerge();
                    }
                    screen.method_25419();
                }
            } else {
                screen.method_25419();
                client.method_1507((class_437)new ItemListScreen());
            }
        });
        this.screen = screen;
        this.forgetOrRememberEnabled = forgetOrRememberEnabled;
        MemoryDatabase database = MemoryDatabase.getCurrent();
        class_310 client = class_310.method_1551();
        if (database != null && client.field_1687 != null && MemoryUtils.getLatestPos() != null) {
            this.isRemembered = database.positionExists(client.field_1687.method_27983().method_29177(), MemoryUtils.getLatestPos());
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.reposition();
        boolean bl = this.field_22762 = mouseX >= this.field_22760 && mouseY >= this.field_22761 && mouseX < this.field_22760 + this.field_22758 && mouseY < this.field_22761 + this.field_22759;
        if (this.field_22764) {
            this.method_25359(matrices, mouseX, mouseY, delta);
        }
        if (this.method_25405(mouseX, mouseY)) {
            if (this.shouldShowAltButton()) {
                this.screen.method_25424(matrices, (class_2561)(this.shouldShowRememberButton() ? new class_2588("chesttracker.gui.remember_location") : new class_2588("chesttracker.gui.delete_location")), mouseX, mouseY);
            } else {
                this.screen.method_25424(matrices, (class_2561)new class_2588("chesttracker.gui.title"), mouseX, mouseY);
            }
        }
    }

    private boolean shouldShowAltButton() {
        return class_437.method_25442() && this.forgetOrRememberEnabled;
    }

    private boolean shouldShowRememberButton() {
        return !this.isRemembered && !ChestTracker.CONFIG.miscOptions.rememberNewChests && !MemoryUtils.wasLastEnderchest();
    }

    private void reposition() {
        if (class_310.method_1551().field_1724 != null) {
            this.method_1893(ButtonPositions.getX(this.screen, 0), ButtonPositions.getY(this.screen, 0));
        }
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        if (this.shouldShowAltButton()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)(this.shouldShowRememberButton() ? TEXTURE_REMEMBER : TEXTURE_FORGET));
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE_MAIN);
        }
        int offset = 0;
        if (this.method_25367()) {
            offset = 9;
        }
        RenderSystem.enableDepthTest();
        ChestTrackerButtonWidget.method_25290((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (float)0.0f, (float)offset, (int)this.field_22758, (int)this.field_22759, (int)9, (int)18);
        if (this.method_25367()) {
            this.method_25352(matrices, mouseX, mouseY);
        }
    }
}

