/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonClientScreen;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WLabeledSlider;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WTabPanel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WToggleButton;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import io.github.cottonmc.cotton.gui.widget.icon.TextureIcon;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.chesttracker.config.ChestTrackerConfig;
import red.jackf.chesttracker.gui.widgets.WHeldButton;
import red.jackf.chesttracker.gui.widgets.WItemListPanel;
import red.jackf.chesttracker.gui.widgets.WPageButton;
import red.jackf.chesttracker.gui.widgets.WUpdatableTextField;
import red.jackf.chesttracker.memory.MemoryDatabase;
import red.jackf.chesttracker.memory.MemoryUtils;
import red.jackf.chesttracker.mixins.AccessorWTabPanel;

@Environment(value=EnvType.CLIENT)
public class ItemListScreen
extends CottonClientScreen {
    public ItemListScreen() {
        super((GuiDescription)new Gui());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode) && !(this.description.getFocus() instanceof WTextField)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static class Gui
    extends LightweightGuiDescription {
        private static final Map<class_2960, class_1799> knownIcons = new HashMap<class_2960, class_1799>();
        private static final int SIDE_PADDING = 0;
        private static final int TOP_PADDING = 36;
        private static final int LEFT_ADDITIONAL_PADDING = 0;
        private static final int BEVEL_PADDING = 6;
        private static final int BOTTOM_PADDING = 17;
        private static final class_2585 BLANK_TEXT = new class_2585("-");
        private final Map<class_2960, WItemListPanel> ITEM_LISTS = new HashMap<class_2960, WItemListPanel>();

        public Gui() {
            int width = 18 * ChestTracker.CONFIG.visualOptions.columnCount + 0 + 0 + 12;
            int height = 18 * ChestTracker.CONFIG.visualOptions.rowCount + 0 + 36 + 12 + (ChestTracker.CONFIG.visualOptions.hideDeleteButton ? 0 : 17);
            class_310 mc = class_310.method_1551();
            WTabPanel tabPanel = new WTabPanel();
            tabPanel.setSize(width, height);
            this.setRootPanel((WPanel)tabPanel);
            MemoryDatabase database = MemoryDatabase.getCurrent();
            if (database != null) {
                int selectedTabIndex = -1;
                int currentIndex = 0;
                class_2960 currentWorld = mc.field_1687 != null ? mc.field_1687.method_27983().method_29177() : class_2874.field_26752;
                for (class_2960 id : database.getDimensions()) {
                    var dimensionPanel = new WPlainPanel(){
                        private WUpdatableTextField searchBar = null;

                        public void onShown() {
                            super.onShown();
                            if (this.searchBar != null) {
                                this.searchBar.requestFocus();
                            }
                        }
                    };
                    dimensionPanel.setSize(width, height);
                    tabPanel.add(new WTabPanel.Tab.Builder((WWidget)dimensionPanel).icon((Icon)new ItemIcon(knownIcons.getOrDefault(id, new class_1799((class_1935)class_1802.field_8465)))).tooltip(new class_2561[]{new class_2585(id.toString())}).build());
                    WItemListPanel itemList = new WItemListPanel(ChestTracker.CONFIG.visualOptions.columnCount, ChestTracker.CONFIG.visualOptions.rowCount);
                    dimensionPanel.add((WWidget)itemList, 6, 42, 18 * ChestTracker.CONFIG.visualOptions.columnCount, 18 * ChestTracker.CONFIG.visualOptions.rowCount);
                    this.ITEM_LISTS.put(id, itemList);
                    dimensionPanel.add((WWidget)new WLabel((class_2561)new class_2588("chesttracker.gui.title")), 6, 6);
                    WUpdatableTextField searchField = new WUpdatableTextField((class_2561)new class_2588("chesttracker.gui.search_field_start"));
                    searchField.setOnTextChanged(itemList::setFilter);
                    dimensionPanel.searchBar = searchField;
                    searchField.setHost((GuiDescription)this);
                    dimensionPanel.add((WWidget)searchField, 6, 18, 18 * (ChestTracker.CONFIG.visualOptions.columnCount - 2) - 1, 20);
                    WPageButton previousButton = new WPageButton(true, (class_2561)new class_2588("chesttracker.gui.previous_page"), false);
                    WPageButton nextButton = new WPageButton(false, (class_2561)new class_2588("chesttracker.gui.next_page"), false);
                    previousButton.setOnClick(itemList::previousPage);
                    nextButton.setOnClick(itemList::nextPage);
                    dimensionPanel.add((WWidget)previousButton, width - 0 - 35 - 6, 20, 16, 16);
                    dimensionPanel.add((WWidget)nextButton, width - 0 - 17 - 6, 20, 16, 16);
                    WLabel counter = new WLabel((class_2561)new class_2585("not loaded")){

                        public void addTooltip(TooltipBuilder tooltip) {
                            super.addTooltip(tooltip);
                            tooltip.add(new class_2561[]{new class_2588("chesttracker.gui.scroll_tip")});
                        }
                    };
                    dimensionPanel.add((WWidget)counter, width - 0 - 80 - 6, 6, 80, 12);
                    counter.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                    itemList.setPageChangeHook((current, max) -> {
                        counter.setText((class_2561)new class_2588("chesttracker.gui.page_count", new Object[]{current, max}));
                        previousButton.setEnabled(current != 1);
                        nextButton.setEnabled(!current.equals(max));
                    });
                    itemList.setItems(database.getItems(id));
                    if (!ChestTracker.CONFIG.visualOptions.hideDeleteButton) {
                        WHeldButton resetButton = new WHeldButton((class_2561)new class_2588("chesttracker.gui.reset_button"), (class_2561)new class_2588("chesttracker.gui.reset_button_alt"), 40);
                        dimensionPanel.add((WWidget)resetButton, 6, height - 20, width - 12, 20);
                        resetButton.setOnClick(() -> {
                            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
                            database.clearDimension(id);
                            itemList.setItems(Collections.emptyList());
                        });
                    }
                    if (id.equals((Object)currentWorld)) {
                        selectedTabIndex = currentIndex;
                    }
                    ++currentIndex;
                }
                WPlainPanel settingsPanel = new WPlainPanel();
                settingsPanel.setSize(width, height);
                WTabPanel.Tab tab = new WTabPanel.Tab.Builder((WWidget)settingsPanel).tooltip(new class_2561[]{new class_2588("chesttracker.gui.settings")}).icon((Icon)new TextureIcon(ChestTracker.id("textures/icon.png"))).build();
                tabPanel.add(tab);
                WLabel addNewChestsToggleLabel = new WLabel((class_2561)new class_2588("chesttracker.gui.settings.remember_chests"));
                settingsPanel.add((WWidget)addNewChestsToggleLabel, 6, 6);
                WToggleButton addNewChestsToggle = new WToggleButton();
                settingsPanel.add((WWidget)addNewChestsToggle, width - 6 - 17, 1);
                addNewChestsToggle.setToggle(ChestTracker.CONFIG.miscOptions.rememberNewChests);
                addNewChestsToggle.setOnToggle(newValue -> {
                    ChestTracker.CONFIG.miscOptions.rememberNewChests = newValue;
                    AutoConfig.getConfigHolder(ChestTrackerConfig.class).save();
                });
                WHeldButton deleteUnnamed = new WHeldButton((class_2561)new class_2588("chesttracker.gui.delete_unnamed"), (class_2561)new class_2588("chesttracker.gui.reset_button_alt"), 30);
                settingsPanel.add((WWidget)deleteUnnamed, 6, 18, width - 12, 20);
                deleteUnnamed.setOnClick(() -> {
                    if (mc.field_1724 == null) {
                        return;
                    }
                    database.getAllMemories(currentWorld).stream().filter(memory -> memory.getTitle() == null && memory.getPosition() != null).forEach(memory -> database.removePos(currentWorld, memory.getPosition()));
                    this.updateItemList(database, currentWorld);
                });
                WLabeledSlider rangeSlider = new WLabeledSlider(1, 98);
                settingsPanel.add((WWidget)rangeSlider, 6, 42);
                rangeSlider.setSize(width - 12, 20);
                rangeSlider.setLabelUpdater(Gui::getSliderText);
                rangeSlider.setValue(ChestTracker.CONFIG.miscOptions.searchRange, true);
                rangeSlider.setDraggingFinishedListener(value -> {
                    ChestTracker.CONFIG.miscOptions.searchRange = value;
                    AutoConfig.getConfigHolder(ChestTrackerConfig.class).save();
                });
                rangeSlider.setLabel(Gui.getSliderText(ChestTracker.CONFIG.miscOptions.searchRange));
                WHeldButton deleteOutside = new WHeldButton((class_2561)BLANK_TEXT, (class_2561)new class_2588("chesttracker.gui.reset_button_alt"), 30);
                settingsPanel.add((WWidget)deleteOutside, 6, 66, width - 12, 20);
                WHeldButton deleteInside = new WHeldButton((class_2561)BLANK_TEXT, (class_2561)new class_2588("chesttracker.gui.reset_button_alt"), 30);
                settingsPanel.add((WWidget)deleteInside, 6, 90, width - 12, 20);
                rangeSlider.setValueChangeListener(value -> Gui.updateDeleteButtonLabels(deleteInside, deleteOutside, value));
                Gui.updateDeleteButtonLabels(deleteInside, deleteOutside, ChestTracker.CONFIG.miscOptions.searchRange);
                deleteInside.setOnClick(() -> {
                    if (mc.field_1724 == null) {
                        return;
                    }
                    database.getAllMemories(currentWorld).stream().filter(memory -> memory.getPosition() != null && memory.getPosition().method_10262((class_2382)mc.field_1724.method_24515()) <= (double)ChestTracker.getSquareSearchRange()).forEach(memory -> database.removePos(currentWorld, memory.getPosition()));
                    this.updateItemList(database, currentWorld);
                });
                deleteOutside.setOnClick(() -> {
                    if (mc.field_1724 == null) {
                        return;
                    }
                    database.getAllMemories(currentWorld).stream().filter(memory -> memory.getPosition() != null && memory.getPosition().method_10262((class_2382)mc.field_1724.method_24515()) > (double)ChestTracker.getSquareSearchRange()).forEach(memory -> database.removePos(currentWorld, memory.getPosition()));
                    this.updateItemList(database, currentWorld);
                });
                WButton showAll = new WButton((class_2561)new class_2588("chesttracker.gui.show_all"));
                settingsPanel.add((WWidget)showAll, 6, 114, width - 12, 20);
                showAll.setOnClick(() -> ChestTracker.startRenderingForLocations(database.getAllMemories(currentWorld)));
                if (!ChestTracker.CONFIG.visualOptions.hideDatabaseInfo) {
                    WLabel dimensionLabel = new WLabel((class_2561)new class_2585(currentWorld.toString()));
                    settingsPanel.add((WWidget)dimensionLabel, 6, height - 6 - 12, 80, 12);
                    WLabel databaseName = new WLabel((class_2561)new class_2585(database.getId()));
                    settingsPanel.add((WWidget)databaseName, 6, height - 6, 80, 12);
                } else {
                    WLabel dimensionLabel = new WLabel((class_2561)new class_2585(currentWorld.toString()));
                    settingsPanel.add((WWidget)dimensionLabel, 6, height - 6, 80, 12);
                }
                if (selectedTabIndex == -1) {
                    ((AccessorWTabPanel)tabPanel).getMainPanel().setSelectedIndex(currentIndex);
                } else {
                    ((AccessorWTabPanel)tabPanel).getMainPanel().setSelectedIndex(selectedTabIndex);
                }
            }
        }

        private void updateItemList(MemoryDatabase database, class_2960 currentWorld) {
            if (this.ITEM_LISTS.containsKey(currentWorld)) {
                this.ITEM_LISTS.get(currentWorld).setItems(database.getItems(currentWorld));
            }
        }

        private static void updateDeleteButtonLabels(WHeldButton deleteInside, WHeldButton deleteOutside, int rawValue) {
            if (rawValue == 98) {
                deleteInside.setEnabled(false);
                deleteOutside.setEnabled(false);
                deleteInside.setText((class_2561)BLANK_TEXT);
                deleteOutside.setText((class_2561)BLANK_TEXT);
            } else {
                deleteInside.setEnabled(true);
                deleteOutside.setEnabled(true);
                deleteInside.setText((class_2561)new class_2588("chesttracker.gui.delete_inside_range", new Object[]{ChestTracker.sliderValueToRange(rawValue)}));
                deleteOutside.setText((class_2561)new class_2588("chesttracker.gui.delete_outside_range", new Object[]{ChestTracker.sliderValueToRange(rawValue)}));
            }
        }

        private static class_2561 getSliderText(int sliderValue) {
            int finalValue = ChestTracker.sliderValueToRange(sliderValue);
            return new class_2588("chesttracker.gui.range").method_10852((class_2561)(finalValue == Integer.MAX_VALUE ? new class_2588("options.framerateLimit.max") : new class_2588("chesttracker.gui.block_range", new Object[]{finalValue})));
        }

        static {
            knownIcons.put(class_2874.field_26752, new class_1799((class_1935)class_1802.field_8270));
            knownIcons.put(class_2874.field_26753, new class_1799((class_1935)class_1802.field_8328));
            knownIcons.put(class_2874.field_26754, new class_1799((class_1935)class_1802.field_20399));
            knownIcons.put(MemoryUtils.ENDER_CHEST_ID, new class_1799((class_1935)class_1802.field_8466));
        }
    }
}

