/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.ChestTracker;
import red.jackf.whereisit.WhereIsItClient;

@Environment(value=EnvType.CLIENT)
public class WItemListPanel
extends WGridPanel {
    private static final class_2960 SLOT = ChestTracker.id("textures/slot.png");
    private static final class_2960 SLOT_RED = ChestTracker.id("textures/slot_red.png");
    private static final class_2583 TOOLTIP_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1060);
    private final int columns;
    private final int rows;
    private List<class_1799> items = Collections.emptyList();
    private List<class_1799> filteredItems = Collections.emptyList();
    @Nullable
    private BiConsumer<Integer, Integer> pageChangeHook = null;
    private String filter = "";
    private int currentPage = 1;
    private int pageCount = 1;
    private boolean usable = true;

    public WItemListPanel(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
    }

    private static class_2561 getCountText(class_1799 stack) {
        return new class_2585("" + stack.method_7947()).method_10862(TOOLTIP_STYLE);
    }

    private static String getLabel(int count) {
        if (count < 1000) {
            return "" + count;
        }
        if (count < 1000000) {
            return count / 1000 + "k";
        }
        if (count < 1000000000) {
            return count / 1000000 + "M";
        }
        return count / 1000000000 + "G";
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    public void setItems(List<class_1799> items) {
        this.items = items.stream().sorted(Collections.reverseOrder(Comparator.comparingInt(class_1799::method_7947))).collect(Collectors.toList());
        this.updateFilter();
    }

    private void updateFilter() {
        this.filteredItems = this.items.stream().filter(stack -> stack.method_7964().getString().toLowerCase().contains(this.filter) || stack.method_7938() && stack.method_7909().method_7864(stack).getString().toLowerCase().contains(this.filter) || stack.method_7969() != null && stack.method_7969().toString().toLowerCase().contains(this.filter)).collect(Collectors.toList());
        this.pageCount = (this.filteredItems.size() - 1) / (this.columns * this.rows) + 1;
        this.currentPage = Math.min(this.currentPage, this.pageCount);
        if (this.pageChangeHook != null) {
            this.pageChangeHook.accept(this.currentPage, this.pageCount);
        }
    }

    public void paint(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        int startIndex;
        super.paint(matrices, x, y, mouseX, mouseY);
        RenderSystem.enableDepthTest();
        class_310 mc = class_310.method_1551();
        class_918 renderer = mc.method_1480();
        int cellsPerPage = this.columns * this.rows;
        for (int i = startIndex = cellsPerPage * (this.currentPage - 1); i < Math.min(startIndex + cellsPerPage, this.filteredItems.size()); ++i) {
            class_1799 stack = this.filteredItems.get(i);
            int renderX = x + 18 * (i % cellsPerPage % this.columns);
            int renderY = y + 18 * (i % cellsPerPage / this.columns);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)SLOT);
            class_332.method_25291((class_4587)matrices, (int)renderX, (int)renderY, (int)10, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            renderer.field_4730 = 100.0f;
            renderer.method_27953(stack, renderX + 1, renderY + 1);
            renderer.method_4022(mc.field_1772, stack, renderX + 1, renderY + 1, WItemListPanel.getLabel(stack.method_7947()));
            renderer.field_4730 = 0.0f;
            int mouseXAbs = (int)(mc.field_1729.method_1603() / mc.method_22683().method_4495());
            int mouseYAbs = (int)(mc.field_1729.method_1604() / mc.method_22683().method_4495());
            if (renderX > mouseXAbs || mouseXAbs >= renderX + 18 || renderY > mouseYAbs || mouseYAbs >= renderY + 18) continue;
            matrices.method_22904(0.0, 0.0, 400.0);
            class_332.method_25294((class_4587)matrices, (int)(renderX + 1), (int)(renderY + 1), (int)(renderX + 17), (int)(renderY + 17), (int)0x5AFFFFFF);
            matrices.method_22904(0.0, 0.0, -400.0);
        }
    }

    public void nextPage() {
        this.setPage(this.currentPage + 1);
    }

    public void previousPage() {
        this.setPage(this.currentPage - 1);
    }

    public InputResult onMouseScroll(int x, int y, double amount) {
        this.setPage(this.currentPage - (int)amount);
        return InputResult.PROCESSED;
    }

    private void setPage(int newPage) {
        this.currentPage = class_3532.method_15340((int)newPage, (int)1, (int)this.pageCount);
        if (this.pageChangeHook != null) {
            this.pageChangeHook.accept(this.currentPage, this.pageCount);
        }
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)(1.0f + 0.4f * (float)(this.currentPage - 1) / (float)this.pageCount)));
    }

    private void searchItem(int x, int y) {
        int cellsPerPage = this.columns * this.rows;
        int startIndex = cellsPerPage * (this.currentPage - 1);
        int relX = x / 18;
        int relY = y / 18;
        int itemIndex = startIndex + relX + relY * this.columns;
        if (itemIndex < this.filteredItems.size() && class_310.method_1551().field_1724 != null) {
            class_1799 stack = this.filteredItems.get(itemIndex);
            WhereIsItClient.searchForItem((class_1792)stack.method_7909(), (boolean)class_437.method_25442(), (class_2487)stack.method_7969());
        }
    }

    public InputResult onClick(int x, int y, int button) {
        if (this.usable && button == 0) {
            this.searchItem(x, y);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    public void renderTooltip(class_4587 matrices, int x, int y, int tX, int tY) {
        int cellsPerPage = this.columns * this.rows;
        int startIndex = cellsPerPage * (this.currentPage - 1);
        int relX = (tX - this.x) / 18;
        int relY = (tY - this.y - 30) / 18;
        int itemIndex = startIndex + relX + relY * this.columns;
        if (itemIndex < this.filteredItems.size()) {
            class_1799 stack = this.filteredItems.get(itemIndex);
            List tooltips = stack.method_7950(null, (class_1836)class_1836.class_1837.field_8934);
            Optional tooltipData = stack.method_32347();
            tooltips.add(WItemListPanel.getCountText(stack));
            class_437 screen = class_310.method_1551().field_1755;
            if (screen != null) {
                screen.method_32634(matrices, tooltips, tooltipData, tX + x, tY + y);
            }
        } else {
            super.renderTooltip(matrices, x, y, tX, tY);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.updateFilter();
    }

    public void setPageChangeHook(@Nullable BiConsumer<Integer, Integer> pageChangeHook) {
        this.pageChangeHook = pageChangeHook;
    }
}

